/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.cassandra.CassandraProperties;
import org.springframework.boot.autoconfigure.cassandra.CqlSessionBuilderCustomizer;
import org.springframework.boot.autoconfigure.cassandra.DriverConfigLoaderBuilderCustomizer;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;

public class CassandraInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private final CassandraProperties properties;

    public CassandraInitializer(CassandraProperties properties) {
        this.properties = properties;
    }

    public void initialize(GenericApplicationContext context) {
        CassandraAutoConfiguration configuration = new CassandraAutoConfiguration();
        context.registerBean(CqlSession.class, () -> configuration.cassandraSession((CqlSessionBuilder)context.getBean(CqlSessionBuilder.class)), new BeanDefinitionCustomizer[0]);
        context.registerBean(CqlSessionBuilder.class, () -> configuration.cassandraSessionBuilder(this.properties, (DriverConfigLoader)context.getBean(DriverConfigLoader.class), context.getBeanProvider(CqlSessionBuilderCustomizer.class)), new BeanDefinitionCustomizer[0]);
        context.registerBean(DriverConfigLoader.class, () -> configuration.cassandraDriverConfigLoader(this.properties, context.getBeanProvider(DriverConfigLoaderBuilderCustomizer.class)), new BeanDefinitionCustomizer[0]);
    }
}

