/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.NativeDetector;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.nativex.GeneratedClassNotFoundException;
import org.springframework.util.ClassUtils;

public class NativeListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final String GENERATED_CLASS = "org.springframework.aot.StaticSpringFactories";
    private static final boolean generatedClassPresent = ClassUtils.isPresent((String)"org.springframework.aot.StaticSpringFactories", null);
    private static final Log logger = LogFactory.getLog(NativeListener.class);

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        if (!NativeDetector.inNativeImage() && !generatedClassPresent) {
            throw new GeneratedClassNotFoundException(GENERATED_CLASS);
        }
        logger.info((Object)"This application is bootstrapped with code generated with Spring AOT");
        ConfigurableEnvironment environment = event.getEnvironment();
        Properties props = new Properties();
        props.put("spring.aop.proxy-target-class", "false");
        props.put("spring.cloud.refresh.enabled", "false");
        props.put("spring.sleuth.async.enabled", "false");
        props.put("spring.devtools.restart.enabled", "false");
        environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("native", props));
    }

    static {
        if (!NativeDetector.inNativeImage()) {
            System.setProperty("org.graalvm.nativeimage.imagecode", "runtime");
        }
        if (ClassUtils.isPresent((String)"org.hibernate.Session", null)) {
            System.setProperty("hibernate.bytecode.provider", "none");
        }
    }
}

