/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationListenerMethodAdapter;
import org.springframework.context.event.DefaultEventListenerFactory;
import org.springframework.context.event.EventExpressionEvaluator;
import org.springframework.context.event.EventListenerFactory;
import org.springframework.context.event.EventListenerMetadata;
import org.springframework.context.support.GenericApplicationContext;

public class EventListenerRegistrar
implements SmartInitializingSingleton {
    private static final EventListenerFactory DEFAULT_EVENT_LISTENER_FACTORY = new DefaultEventListenerFactory();
    private final EventExpressionEvaluator evaluator = new EventExpressionEvaluator();
    private final GenericApplicationContext context;
    private final Collection<EventListenerMetadata> eventListenersMetadata;

    public EventListenerRegistrar(GenericApplicationContext context, List<EventListenerMetadata> eventListenersMetadata) {
        this.context = context;
        this.eventListenersMetadata = new ArrayList<EventListenerMetadata>(eventListenersMetadata);
    }

    public void afterSingletonsInstantiated() {
        for (EventListenerMetadata eventListenerMetadata : this.eventListenersMetadata) {
            this.register(eventListenerMetadata);
        }
    }

    void register(EventListenerMetadata metadata) {
        EventListenerFactory factory = this.determineEventListenerFactory(this.context, metadata.getEventListenerFactoryBeanName());
        ApplicationListener applicationListener = factory.createApplicationListener(metadata.getBeanName(), metadata.getBeanType(), metadata.getMethod());
        if (applicationListener instanceof ApplicationListenerMethodAdapter) {
            ((ApplicationListenerMethodAdapter)applicationListener).init((ApplicationContext)this.context, this.evaluator);
        }
        this.context.addApplicationListener(applicationListener);
    }

    private EventListenerFactory determineEventListenerFactory(GenericApplicationContext context, String factoryBeanName) {
        return factoryBeanName != null ? (EventListenerFactory)context.getBean(factoryBeanName, EventListenerFactory.class) : DEFAULT_EVENT_LISTENER_FACTORY;
    }
}

