/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test;

import java.util.Collections;
import org.springframework.aot.test.AotCacheAwareContextLoaderDelegate;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.MergedContextConfiguration;

class AotMergedContextConfiguration
extends MergedContextConfiguration {
    private static final long serialVersionUID = 1963364911008547843L;
    private final Class<? extends ApplicationContextInitializer<?>> contextInitializerClass;
    private final MergedContextConfiguration original;

    AotMergedContextConfiguration(Class<?> testClass, Class<? extends ApplicationContextInitializer<?>> contextInitializerClass, MergedContextConfiguration original, AotCacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, @Nullable MergedContextConfiguration parent) {
        super(testClass, null, null, Collections.singleton(contextInitializerClass), null, null, (CacheAwareContextLoaderDelegate)cacheAwareContextLoaderDelegate, parent);
        this.contextInitializerClass = contextInitializerClass;
        this.original = original;
    }

    MergedContextConfiguration getOriginal() {
        return this.original;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        AotMergedContextConfiguration that = (AotMergedContextConfiguration)((Object)other);
        if (!this.contextInitializerClass.equals(that.contextInitializerClass)) {
            return false;
        }
        return !(this.getParent() == null ? that.getParent() != null : !this.getParent().equals((Object)that.getParent()));
    }

    public int hashCode() {
        int result = this.contextInitializerClass.hashCode();
        result = 31 * result + (this.getParent() != null ? this.getParent().hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("testClass", (Object)this.getTestClass().getName()).append("contextInitializerClass", (Object)this.contextInitializerClass.getName()).append("original", (Object)this.original).append("parent", (Object)this.getParent()).toString();
    }
}

