/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.util.ArrayList;
import java.util.List;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.BuildTimeProxyDescriptor;
import org.springframework.aop.framework._AdvisedSupportAware;
import org.springframework.core.DecoratingProxy;

public class ProxyConfiguration {
    private String targetClass;
    private List<String> interfaces;
    private boolean exposeProxy;
    private boolean isStatic;
    private boolean isFrozen;
    private boolean isOpaque;

    public ProxyConfiguration(String targetClass, List<String> interfaces, boolean exposeProxy, boolean isStatic, boolean isFrozen, boolean isOpaque) {
        this.targetClass = targetClass;
        this.interfaces = new ArrayList<String>();
        if (interfaces != null) {
            for (String intf : interfaces) {
                if (intf.equals(_AdvisedSupportAware.class.getName())) continue;
                this.interfaces.add(intf);
            }
        }
        this.exposeProxy = exposeProxy;
        this.isStatic = isStatic;
        this.isFrozen = isFrozen;
        this.isOpaque = isOpaque;
    }

    public static ProxyConfiguration get(BuildTimeProxyDescriptor pd, ClassLoader classLoader) {
        ArrayList<String> interfaceTypes = new ArrayList<String>();
        if (pd.getInterfaceTypes() != null) {
            for (String interfaceTypename : pd.getInterfaceTypes()) {
                interfaceTypes.add(interfaceTypename);
            }
        }
        ProxyConfiguration.completeProxiedInterfaces(pd.getTargetClassType(), pd.isFeatureSet(8), false, classLoader, interfaceTypes);
        return new ProxyConfiguration(pd.getTargetClassType(), interfaceTypes, pd.isFeatureSet(1), pd.isFeatureSet(2), pd.isFeatureSet(4), pd.isFeatureSet(8));
    }

    public static ProxyConfiguration get(AdvisedSupport advised, ClassLoader classLoader) {
        Class[] proxiedInterfaces = advised.getProxiedInterfaces();
        ArrayList<String> interfaces = new ArrayList<String>();
        if (proxiedInterfaces != null) {
            for (Class proxiedInterface : proxiedInterfaces) {
                interfaces.add(proxiedInterface.getName());
            }
        }
        ProxyConfiguration.completeProxiedInterfaces(advised, false, classLoader, interfaces);
        return new ProxyConfiguration(advised.getTargetClass().getName(), interfaces, advised.isExposeProxy(), advised.getTargetSource().isStatic(), advised.isFrozen(), advised.isOpaque());
    }

    static void completeProxiedInterfaces(AdvisedSupport advised, boolean decoratingProxy, ClassLoader classLoader, List<String> specifiedInterfaces) {
        ProxyConfiguration.completeProxiedInterfaces(advised.getTargetClass().getName(), advised.isOpaque(), decoratingProxy, classLoader, specifiedInterfaces);
    }

    static void completeProxiedInterfaces(String targetClassName, boolean isOpaque, boolean decoratingProxy, ClassLoader classLoader, List<String> specifiedInterfaces) {
        boolean addDecoratingProxy;
        boolean addSpringProxy = !specifiedInterfaces.contains(SpringProxy.class.getName());
        boolean addAdvised = !isOpaque && !specifiedInterfaces.contains(Advised.class.getName());
        boolean bl = addDecoratingProxy = decoratingProxy && !specifiedInterfaces.contains(DecoratingProxy.class.getName());
        if (addSpringProxy) {
            specifiedInterfaces.add(SpringProxy.class.getName());
        }
        if (addAdvised) {
            specifiedInterfaces.add(Advised.class.getName());
        }
        if (addDecoratingProxy) {
            specifiedInterfaces.add(DecoratingProxy.class.getName());
        }
    }

    public void setTargetClass(String targetClass) {
        this.targetClass = targetClass;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public List<String> getProxiedInterfaces() {
        return this.interfaces;
    }

    public boolean isInterfaceProxied(String intface) {
        return this.interfaces.contains(intface);
    }

    public boolean isExposeProxy() {
        return this.exposeProxy;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProxyConfiguration that = (ProxyConfiguration)object;
        if (this.exposeProxy != that.exposeProxy) {
            return false;
        }
        if (this.isStatic != that.isStatic) {
            return false;
        }
        if (this.isFrozen != that.isFrozen) {
            return false;
        }
        if (!this.targetClass.equals(that.targetClass)) {
            return false;
        }
        return this.interfaces.equals(that.interfaces);
    }

    public void setInterfaces(String interfaceName) {
        this.interfaces = new ArrayList<String>();
        this.interfaces.add(interfaceName);
    }

    public void setInterfaces(List<String> interfaceNames) {
        this.interfaces = interfaceNames;
    }

    public boolean includesInterface(String interfaceName) {
        return this.interfaces.contains(interfaceName);
    }

    public void addInterface(String name) {
        this.interfaces.add(name);
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public int hashCode() {
        int result = this.targetClass.hashCode();
        if (!this.interfaces.isEmpty()) {
            for (String intface : this.interfaces) {
                result = 37 * result + intface.hashCode();
            }
        }
        result = 37 * result + (this.exposeProxy ? 1 : 0);
        result = 37 * result + (this.isStatic ? 1 : 0);
        result = 37 * result + (this.isFrozen ? 1 : 0);
        result = 37 * result + (this.isOpaque ? 1 : 0);
        return result;
    }

    public String getProxyClassName() {
        StringBuilder name = new StringBuilder();
        name.append(this.targetClass);
        name.append("$$SpringProxy$");
        name.append(Integer.toHexString(this.hashCode()));
        return name.toString();
    }

    public String asHint() {
        StringBuilder s = new StringBuilder();
        s.append("@AotProxyHint(");
        boolean commaNeeded = false;
        if (this.targetClass != null) {
            s.append("targetClass=").append(this.targetClass).append(".class");
            commaNeeded = true;
        }
        ArrayList<String> filteredInterfaces = new ArrayList<String>();
        for (String intface : this.interfaces) {
            if (intface.equals(Advised.class.getName()) || intface.equals(SpringProxy.class.getName())) continue;
            filteredInterfaces.add(intface);
        }
        if (!filteredInterfaces.isEmpty()) {
            if (commaNeeded) {
                s.append(", ");
            }
            s.append("interfaces={");
            for (int i = 0; i < filteredInterfaces.size(); ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append((String)filteredInterfaces.get(i)).append(".class");
            }
            s.append("}");
            commaNeeded = true;
        }
        if (this.exposeProxy || this.isStatic || this.isFrozen || this.isOpaque) {
            if (commaNeeded) {
                s.append(", ");
            }
            s.append("proxyFeatures = ");
            boolean orNeeded = false;
            if (this.isStatic) {
                if (orNeeded) {
                    s.append("|");
                }
                s.append("ProxyBits.IS_STATIC");
                orNeeded = true;
            }
            if (this.isOpaque) {
                if (orNeeded) {
                    s.append("|");
                }
                s.append("ProxyBits.IS_OPAQUE");
                orNeeded = true;
            }
            if (this.isFrozen) {
                if (orNeeded) {
                    s.append("|");
                }
                s.append("ProxyBits.IS_FROZEN");
                orNeeded = true;
            }
            if (this.exposeProxy) {
                if (orNeeded) {
                    s.append("|");
                }
                s.append("ProxyBits.EXPOSE_PROXY");
                orNeeded = true;
            }
            commaNeeded = true;
        }
        s.append(")");
        return s.toString();
    }
}

