/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex.substitutions.framework.test;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.nativex.substitutions.OnlyIfPresent;
import org.springframework.test.context.TestExecutionListener;

@TargetClass(className="org.springframework.test.context.support.AbstractTestContextBootstrapper", onlyWith={OnlyIfPresent.class})
final class Target_AbstractTestContextBootstrapper {
    @Alias
    private Log logger;

    Target_AbstractTestContextBootstrapper() {
    }

    @Substitute
    private List<TestExecutionListener> instantiateListeners(Collection<Class<? extends TestExecutionListener>> classes) {
        ArrayList<TestExecutionListener> listeners = new ArrayList<TestExecutionListener>(classes.size());
        for (Class<? extends TestExecutionListener> listenerClass : classes) {
            try {
                listeners.add((TestExecutionListener)BeanUtils.instantiateClass(listenerClass));
            }
            catch (BeanInstantiationException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof NoClassDefFoundError || cause instanceof NoSuchMethodException) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)String.format("Skipping candidate TestExecutionListener [%s] due to a missing dependency. Specify custom listener classes or make the default listener classes and their required dependencies available. Offending class: [%s]", listenerClass.getName(), cause.getMessage()));
                    continue;
                }
                throw ex;
            }
        }
        return listeners;
    }
}

