/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex.substitutions.boot;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.util.Instantiator;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.nativex.substitutions.OnlyIfPresent;
import org.springframework.nativex.substitutions.WithAot;

@TargetClass(className="org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer$DependsOnDatabaseInitializationPostProcessor", onlyWith={WithAot.class, OnlyIfPresent.class})
final class Target_DatabaseInitializationDependencyConfigurer {
    @Alias
    private Environment environment;

    Target_DatabaseInitializationDependencyConfigurer() {
    }

    @Substitute
    private <T> List<T> getDetectors(ConfigurableListableBeanFactory beanFactory, Class<T> type) {
        List factoryNames = SpringFactoriesLoader.loadFactoryNames(type, (ClassLoader)beanFactory.getBeanClassLoader());
        List factories = SpringFactoriesLoader.loadFactories(type, (ClassLoader)beanFactory.getBeanClassLoader());
        ArrayList missing = new ArrayList(factoryNames);
        for (Object f : factories) {
            missing.remove(f.getClass().getName());
        }
        EnvironmentAwareInstantiator<T> instantiator = new EnvironmentAwareInstantiator<T>(type, this.environment);
        List instantiatedMissingFactories = instantiator.instantiate(beanFactory.getBeanClassLoader(), missing);
        ArrayList result = new ArrayList();
        result.addAll(factories);
        result.addAll(instantiatedMissingFactories);
        AnnotationAwareOrderComparator.sort(result);
        return result;
    }

    public static class EnvironmentAwareInstantiator<T>
    extends Instantiator<T> {
        EnvironmentAwareInstantiator(Class<T> type, Environment environment) {
            super(type, availableParameters -> availableParameters.add(Environment.class, (Object)environment));
        }
    }
}

