/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.lang.reflect.Method;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.ReflectionUtils;

public final class EventListenerMetadata {
    private final String beanName;
    private final Class<?> beanType;
    private final String eventListenerFactoryBeanName;
    private final Method method;

    EventListenerMetadata(Builder builder) {
        this.beanName = builder.beanName;
        this.beanType = builder.beanType;
        this.eventListenerFactoryBeanName = builder.eventListenerFactoryBeanName;
        this.method = builder.method;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public String getEventListenerFactoryBeanName() {
        return this.eventListenerFactoryBeanName;
    }

    public Method getMethod() {
        return this.method;
    }

    public static Builder forBean(String beanName, Class<?> beanType) {
        return new Builder(beanName, beanType);
    }

    public static class Builder {
        private final String beanName;
        private final Class<?> beanType;
        private String eventListenerFactoryBeanName;
        private Method method;

        private Builder(String beanName, Class<?> beanType) {
            this.beanName = beanName;
            this.beanType = beanType;
        }

        public Builder eventListenerFactoryBeanName(String eventListenerFactoryBeanName) {
            this.eventListenerFactoryBeanName = eventListenerFactoryBeanName;
            return this;
        }

        public EventListenerMetadata annotatedMethod(String methodName, Class<?> ... parameterTypes) {
            this.method = this.findMethod(methodName, parameterTypes);
            return new EventListenerMetadata(this);
        }

        private Method findMethod(String methodName, Class<?> ... parameterTypes) {
            Method method = ReflectionUtils.findMethod(this.beanType, (String)methodName, (Class[])parameterTypes);
            if (method == null) {
                throw new IllegalStateException("No method named '" + methodName + "' found on " + this.beanType);
            }
            return AopUtils.selectInvocableMethod((Method)method, this.beanType);
        }
    }
}

