/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex.substitutions.data;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.nativex.substitutions.OnlyIfPresent;
import org.springframework.nativex.substitutions.data.OnlyIfImperativeMongoClient;

@TargetClass(className="org.springframework.data.mongodb.core.convert.LazyLoadingProxyFactory", onlyWith={OnlyIfPresent.class, OnlyIfImperativeMongoClient.class})
public final class Target_LazyLoadingProxyFactory {
    @Alias
    private PersistenceExceptionTranslator exceptionTranslator = null;

    @Substitute
    public Object createLazyLoadingProxy(MongoPersistentProperty property, DbRefResolverCallback callback, Object source) {
        Class propertyType = property.getType();
        LazyLoadingInterceptor interceptor = new LazyLoadingInterceptor(property, callback, source, this.exceptionTranslator);
        if (!propertyType.isInterface()) {
            ProxyFactory factory = new ProxyFactory();
            factory.addAdvice((Advice)interceptor);
            factory.addInterface(LazyLoadingProxy.class);
            factory.setTargetClass(propertyType);
            factory.setProxyTargetClass(true);
            return factory.getProxy(propertyType.getClassLoader());
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        for (Class<?> type : propertyType.getInterfaces()) {
            proxyFactory.addInterface(type);
        }
        proxyFactory.addInterface(LazyLoadingProxy.class);
        proxyFactory.addInterface(propertyType);
        proxyFactory.addAdvice((Advice)interceptor);
        return proxyFactory.getProxy(LazyLoadingProxy.class.getClassLoader());
    }

    @TargetClass(className="org.springframework.data.mongodb.core.convert.LazyLoadingProxyFactory", innerClass={"LazyLoadingInterceptor"}, onlyWith={OnlyIfPresent.class, OnlyIfImperativeMongoClient.class})
    static final class LazyLoadingInterceptor
    implements org.aopalliance.intercept.MethodInterceptor,
    MethodInterceptor,
    Serializable {
        @Alias
        public LazyLoadingInterceptor(MongoPersistentProperty property, DbRefResolverCallback callback, Object source, PersistenceExceptionTranslator exceptionTranslator) {
        }

        @Alias
        public Object invoke(MethodInvocation invocation) throws Throwable {
            return null;
        }

        @Alias
        public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
            return null;
        }
    }
}

