/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex.hint;

import java.util.ArrayList;
import org.springframework.nativex.hint.TypeAccess;

@Deprecated
public class AccessBits {
    public static final int RESOURCE = 1;
    public static final int CLASS = 2;
    public static final int DECLARED_CONSTRUCTORS = 4;
    public static final int DECLARED_METHODS = 8;
    public static final int DECLARED_FIELDS = 16;
    public static final int PUBLIC_METHODS = 32;
    public static final int PUBLIC_CONSTRUCTORS = 64;
    public static final int JNI = 128;
    public static final int QUERY_DECLARED_CONSTRUCTORS = 256;
    public static final int QUERY_DECLARED_METHODS = 512;
    public static final int QUERY_PUBLIC_METHODS = 1024;
    public static final int QUERY_PUBLIC_CONSTRUCTORS = 2048;
    public static final int NONE = 0;
    public static final int FULL_REFLECTION = 126;
    public static final int ALL = 127;
    public static final int ANNOTATION = 34;
    public static final int INTERFACE = 34;
    public static final int LOAD_AND_CONSTRUCT = 6;
    public static final int LOAD_AND_CONSTRUCT_AND_PUBLIC_METHODS = 38;
    private int value;

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object that) {
        if (that instanceof AccessBits) {
            return this.value == ((AccessBits)that).value;
        }
        return false;
    }

    public String toString() {
        return AccessBits.toString(this.value);
    }

    public static TypeAccess[] getAccess(int value) {
        ArrayList<TypeAccess> access = new ArrayList<TypeAccess>();
        if ((value & 0x10) != 0) {
            access.add(TypeAccess.DECLARED_FIELDS);
        }
        if ((value & 4) != 0) {
            access.add(TypeAccess.DECLARED_CONSTRUCTORS);
        }
        if ((value & 0x40) != 0) {
            access.add(TypeAccess.PUBLIC_CONSTRUCTORS);
        }
        if ((value & 8) != 0) {
            access.add(TypeAccess.DECLARED_METHODS);
        }
        if ((value & 0x20) != 0) {
            access.add(TypeAccess.PUBLIC_METHODS);
        }
        if ((value & 0x100) != 0) {
            access.add(TypeAccess.QUERY_DECLARED_CONSTRUCTORS);
        }
        if ((value & 0x800) != 0) {
            access.add(TypeAccess.QUERY_PUBLIC_CONSTRUCTORS);
        }
        if ((value & 0x200) != 0) {
            access.add(TypeAccess.QUERY_DECLARED_METHODS);
        }
        if ((value & 0x400) != 0) {
            access.add(TypeAccess.QUERY_PUBLIC_METHODS);
        }
        return access.toArray(new TypeAccess[0]);
    }

    public AccessBits() {
        this.value = 0;
    }

    public AccessBits(int value) {
        this.value = value;
    }

    public static final AccessBits forValue(int value) {
        return new AccessBits(value);
    }

    public static final AccessBits forBits(int ... bits) {
        int value = 0;
        for (int i = 0; i < bits.length; ++i) {
            value |= bits[i];
        }
        return new AccessBits(value);
    }

    public boolean isResourceAccessRequired() {
        return (this.value & 1) != 0;
    }

    public boolean hasAccess(AccessBits accessBitsToCheck) {
        return (this.value ^ accessBitsToCheck.value) == 0;
    }

    public AccessBits with(AccessBits accessRequired) {
        return AccessBits.forValue(this.value | accessRequired.value);
    }

    public static String toString(Integer value) {
        StringBuilder s = new StringBuilder();
        s.append("ACS(");
        if ((value & 1) != 0) {
            s.append("RES ");
        }
        if ((value & 2) != 0) {
            s.append("CLS ");
        }
        if ((value & 4) != 0) {
            s.append("DCONS ");
        }
        if ((value & 0x40) != 0) {
            s.append("PCONS ");
        }
        if ((value & 8) != 0) {
            s.append("DMETHS ");
        }
        if ((value & 0x20) != 0) {
            s.append("PMETHS ");
        }
        if ((value & 0x10) != 0) {
            s.append("FLDS ");
        }
        if ((value & 0x100) != 0) {
            s.append("QDCONS ");
        }
        if ((value & 0x800) != 0) {
            s.append("QPCONS ");
        }
        if ((value & 0x200) != 0) {
            s.append("QDMETHS ");
        }
        if ((value & 0x400) != 0) {
            s.append("QPMETHS ");
        }
        if (value == 0) {
            s.append("NONE");
        }
        return s.toString().trim() + ")";
    }

    public static boolean isResourceAccessRequired(Integer typeKind) {
        return (typeKind & 1) != 0;
    }

    public int getValue() {
        return this.value;
    }

    public static int compareAccess(int currentAccess, int newAccess) {
        int result = 0;
        if ((currentAccess & 1) == 0 && (newAccess & 1) != 0) {
            result |= 1;
        }
        if ((currentAccess & 2) == 0 && (newAccess & 2) != 0) {
            result |= 2;
        }
        if ((currentAccess & 4) == 0 && (newAccess & 4) != 0) {
            result |= 4;
        }
        if ((currentAccess & 0x40) == 0 && (newAccess & 0x40) != 0) {
            result |= 0x40;
        }
        if ((currentAccess & 8) == 0 && (newAccess & 8) != 0) {
            result |= 8;
        }
        if ((currentAccess & 0x10) == 0 && (newAccess & 0x10) != 0) {
            result |= 0x10;
        }
        if ((currentAccess & 0x20) == 0 && (newAccess & 0x20) != 0) {
            result |= 0x20;
        }
        if ((currentAccess & 0x100) == 0 && (newAccess & 0x100) != 0) {
            result |= 0x100;
        }
        if ((currentAccess & 0x800) == 0 && (newAccess & 0x800) != 0) {
            result |= 0x800;
        }
        if ((currentAccess & 0x200) == 0 && (newAccess & 0x200) != 0) {
            result |= 0x200;
        }
        if ((currentAccess & 0x400) == 0 && (newAccess & 0x400) != 0) {
            result |= 0x400;
        }
        return result;
    }

    public static AccessBits fromTypeAccess(TypeAccess ... accesses) {
        Integer value = 0;
        if (accesses.length == 0) {
            value = 2;
        }
        for (TypeAccess access : accesses) {
            if (TypeAccess.DECLARED_CONSTRUCTORS.equals((Object)access)) {
                value = value | 4;
            }
            if (TypeAccess.PUBLIC_CONSTRUCTORS.equals((Object)access)) {
                value = value | 0x40;
            }
            if (TypeAccess.DECLARED_METHODS.equals((Object)access)) {
                value = value | 8;
            }
            if (TypeAccess.PUBLIC_METHODS.equals((Object)access)) {
                value = value | 0x20;
            }
            if (TypeAccess.DECLARED_FIELDS.equals((Object)access)) {
                value = value | 0x10;
            }
            if (TypeAccess.QUERY_DECLARED_CONSTRUCTORS.equals((Object)access)) {
                value = value | 0x100;
            }
            if (TypeAccess.QUERY_PUBLIC_CONSTRUCTORS.equals((Object)access)) {
                value = value | 0x800;
            }
            if (TypeAccess.QUERY_DECLARED_METHODS.equals((Object)access)) {
                value = value | 0x200;
            }
            if (TypeAccess.QUERY_PUBLIC_METHODS.equals((Object)access)) {
                value = value | 0x400;
            }
            if (TypeAccess.RESOURCE.equals((Object)access)) {
                value = value | 1;
            }
            if (!TypeAccess.JNI.equals((Object)access)) continue;
            value = value | 0x80;
        }
        return new AccessBits(value);
    }

    public static boolean isSet(int value, int mask) {
        return (value & mask) != 0;
    }
}

