/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class AotTestMappings {
    private static final String INITIALIZER_NAME = "org.springframework.aot.TestContextBootstrapInitializer";
    private final Map<String, Supplier<SmartContextLoader>> contextLoaders;
    private final Map<String, Class<? extends ApplicationContextInitializer<?>>> contextInitializers;

    AotTestMappings(Map<String, Supplier<SmartContextLoader>> contextLoaders, Map<String, Class<? extends ApplicationContextInitializer<?>>> contextInitializers) {
        this.contextLoaders = contextLoaders;
        this.contextInitializers = contextInitializers;
    }

    AotTestMappings(String initializerClassName) {
        this(AotTestMappings.loadMap(initializerClassName, "getContextLoaders"), AotTestMappings.loadMap(initializerClassName, "getContextInitializers"));
    }

    AotTestMappings() {
        this(INITIALIZER_NAME);
    }

    boolean isSupportedTestClass(Class<?> testClass) {
        return this.contextLoaders.containsKey(testClass.getName());
    }

    SmartContextLoader getContextLoader(Class<?> testClass) {
        Supplier<SmartContextLoader> supplier = this.contextLoaders.get(testClass.getName());
        return supplier != null ? supplier.get() : null;
    }

    Class<? extends ApplicationContextInitializer<?>> getContextInitializerClass(Class<?> testClass) {
        return this.contextInitializers.get(testClass.getName());
    }

    private static Map loadMap(String className, String methodName) {
        try {
            Class type = ClassUtils.forName((String)className, null);
            Method method = ReflectionUtils.findMethod((Class)type, (String)methodName);
            if (method == null) {
                throw new IllegalStateException(String.format("No %s() method found on %s", methodName, type.getName()));
            }
            return (Map)ReflectionUtils.invokeMethod((Method)method, null);
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Failed to load %s() method in %s", methodName, className), ex);
        }
    }
}

