/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.test.AotTestMappings;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.nativex.AotModeDetector;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.Assert;

public class AotDependencyInjectionTestExecutionListener
extends DependencyInjectionTestExecutionListener {
    private static final Log logger = LogFactory.getLog(AotDependencyInjectionTestExecutionListener.class);
    private static final AotTestMappings aotTestMappings = AotDependencyInjectionTestExecutionListener.getAotTestMappings();

    public void prepareTestInstance(TestContext testContext) throws Exception {
        if (this.isSupportedTestClass(testContext)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Performing dependency injection for test context [" + testContext + "]."));
            }
            this.injectDependenciesInAotMode(testContext);
        } else {
            super.prepareTestInstance(testContext);
        }
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (this.isSupportedTestClass(testContext)) {
            if (Boolean.TRUE.equals(testContext.getAttribute(REINJECT_DEPENDENCIES_ATTRIBUTE))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reinjecting dependencies for test context [" + testContext + "]."));
                }
                this.injectDependenciesInAotMode(testContext);
            }
        } else {
            super.beforeTestMethod(testContext);
        }
    }

    private void injectDependenciesInAotMode(TestContext testContext) throws Exception {
        Class clazz = testContext.getTestClass();
        Object bean = testContext.getTestInstance();
        ApplicationContext applicationContext = testContext.getApplicationContext();
        Assert.state((boolean)(applicationContext instanceof GenericApplicationContext), () -> "AOT ApplicationContext must be a GenericApplicationContext instead of " + applicationContext.getClass().getName());
        ConfigurableListableBeanFactory beanFactory = ((GenericApplicationContext)applicationContext).getBeanFactory();
        AutowiredAnnotationBeanPostProcessor beanPostProcessor = new AutowiredAnnotationBeanPostProcessor();
        beanPostProcessor.setBeanFactory((BeanFactory)beanFactory);
        beanPostProcessor.processInjection(bean);
        beanFactory.initializeBean(bean, clazz.getName() + ".ORIGINAL");
        testContext.removeAttribute(REINJECT_DEPENDENCIES_ATTRIBUTE);
    }

    private boolean isSupportedTestClass(TestContext testContext) {
        return aotTestMappings != null && aotTestMappings.isSupportedTestClass(testContext.getTestClass());
    }

    private static AotTestMappings getAotTestMappings() {
        if (AotModeDetector.isRunningAotTests()) {
            try {
                return new AotTestMappings();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to instantiate AotTestMappings", ex);
            }
        }
        return null;
    }
}

