/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.test.AotMergedContextConfiguration;
import org.springframework.aot.test.AotTestMappings;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.cache.ContextCache;
import org.springframework.test.context.cache.DefaultCacheAwareContextLoaderDelegate;
import org.springframework.util.Assert;

public class AotCacheAwareContextLoaderDelegate
extends DefaultCacheAwareContextLoaderDelegate {
    private static final Log logger = LogFactory.getLog(AotCacheAwareContextLoaderDelegate.class);
    private final AotTestMappings aotTestMappings;

    public AotCacheAwareContextLoaderDelegate() {
        this.aotTestMappings = new AotTestMappings();
    }

    AotCacheAwareContextLoaderDelegate(AotTestMappings aotTestMappings, ContextCache contextCache) {
        super(contextCache);
        this.aotTestMappings = aotTestMappings;
    }

    protected ApplicationContext loadContextInternal(MergedContextConfiguration config) throws Exception {
        SmartContextLoader contextLoader = this.aotTestMappings.getContextLoader(config.getTestClass());
        if (contextLoader != null) {
            Assert.isInstanceOf(AotMergedContextConfiguration.class, (Object)config);
            logger.info((Object)("Loading test ApplicationContext in AOT mode using " + contextLoader));
            return contextLoader.loadContext(((AotMergedContextConfiguration)config).getOriginal());
        }
        return super.loadContextInternal(config);
    }

    public boolean isContextLoaded(MergedContextConfiguration mergedContextConfiguration) {
        return super.isContextLoaded(this.replaceIfNecessary(mergedContextConfiguration));
    }

    public ApplicationContext loadContext(MergedContextConfiguration mergedContextConfiguration) {
        return super.loadContext(this.replaceIfNecessary(mergedContextConfiguration));
    }

    public void closeContext(MergedContextConfiguration mergedContextConfiguration, DirtiesContext.HierarchyMode hierarchyMode) {
        super.closeContext(this.replaceIfNecessary(mergedContextConfiguration), hierarchyMode);
    }

    private MergedContextConfiguration replaceIfNecessary(MergedContextConfiguration mergedContextConfiguration) {
        if (mergedContextConfiguration == null) {
            return null;
        }
        Class testClass = mergedContextConfiguration.getTestClass();
        Class<? extends ApplicationContextInitializer<?>> contextInitializerClass = this.aotTestMappings.getContextInitializerClass(testClass);
        if (contextInitializerClass != null) {
            return new AotMergedContextConfiguration(testClass, contextInitializerClass, mergedContextConfiguration, this, this.replaceIfNecessary(mergedContextConfiguration.getParent()));
        }
        return mergedContextConfiguration;
    }
}

