/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.context.annotation;

import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class ImportAwareBeanPostProcessor
implements BeanPostProcessor {
    private final MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();
    private final Map<String, String> importsMapping;

    public ImportAwareBeanPostProcessor(Map<String, String> importsMapping) {
        this.importsMapping = importsMapping;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (bean instanceof ImportAware) {
            this.setAnnotationMetadata((ImportAware)bean);
        }
        return bean;
    }

    private void setAnnotationMetadata(ImportAware instance) {
        String importingClass = this.getImportingClassFor(instance);
        if (importingClass == null) {
            return;
        }
        try {
            MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(importingClass);
            instance.setImportMetadata(metadataReader.getAnnotationMetadata());
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Failed to read metadata for '%s'", importingClass), ex);
        }
    }

    private String getImportingClassFor(ImportAware instance) {
        String target = ClassUtils.getUserClass((Object)instance).getName();
        return this.importsMapping.get(target);
    }
}

