/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.beans.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.aot.beans.factory.InjectedConstructionResolver;
import org.springframework.aot.beans.factory.InjectedElementAttributes;
import org.springframework.aot.beans.factory.InjectedElementResolver;
import org.springframework.aot.beans.factory.InjectedFieldResolver;
import org.springframework.aot.beans.factory.InjectedMethodResolver;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class BeanDefinitionRegistrar {
    private static final Log logger = LogFactory.getLog(BeanDefinitionRegistrar.class);
    private final String beanName;
    private final Class<?> beanClass;
    private final ResolvableType beanType;
    private final BeanDefinitionBuilder builder;
    private final List<Consumer<RootBeanDefinition>> customizers;
    private Executable instanceCreator;
    private RootBeanDefinition beanDefinition;

    private BeanDefinitionRegistrar(String beanName, Class<?> beanClass, ResolvableType beanType) {
        this.beanName = beanName;
        this.beanClass = beanClass;
        this.beanType = beanType;
        this.builder = BeanDefinitionBuilder.rootBeanDefinition(beanClass);
        this.customizers = new ArrayList<Consumer<RootBeanDefinition>>();
    }

    public static BeanDefinitionRegistrar of(String beanName, ResolvableType beanType) {
        return new BeanDefinitionRegistrar(beanName, beanType.toClass(), beanType);
    }

    public static BeanDefinitionRegistrar of(String beanName, Class<?> beanType) {
        return new BeanDefinitionRegistrar(beanName, beanType, null);
    }

    public static BeanDefinitionRegistrar inner(ResolvableType beanType) {
        return BeanDefinitionRegistrar.of(null, beanType);
    }

    public static BeanDefinitionRegistrar inner(Class<?> beanType) {
        return BeanDefinitionRegistrar.of(null, beanType);
    }

    public BeanDefinitionRegistrar customize(ThrowableConsumer<RootBeanDefinition> beanDefinition) {
        this.customizers.add(beanDefinition);
        return this;
    }

    public BeanDefinitionRegistrar withFactoryMethod(Class<?> declaredType, String name, Class<?> ... parameterTypes) {
        this.instanceCreator = BeanDefinitionRegistrar.getMethod(declaredType, name, parameterTypes);
        return this;
    }

    public BeanDefinitionRegistrar withConstructor(Class<?> ... parameterTypes) {
        this.instanceCreator = BeanDefinitionRegistrar.getConstructor(this.beanClass, parameterTypes);
        return this;
    }

    public BeanDefinitionRegistrar instanceSupplier(ThrowableFunction<BeanInstanceContext, ?> instanceContext) {
        return this.customize(beanDefinition -> beanDefinition.setInstanceSupplier(() -> instanceContext.apply(this.createBeanInstanceContext())));
    }

    public BeanDefinitionRegistrar instanceSupplier(ThrowableSupplier<?> instanceSupplier) {
        return this.customize(beanDefinition -> beanDefinition.setInstanceSupplier((Supplier)instanceSupplier));
    }

    public void register(DefaultListableBeanFactory beanFactory) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Register bean definition with name '" + this.beanName + "'"));
        }
        RootBeanDefinition beanDefinition = this.toBeanDefinition();
        if (this.beanName == null) {
            throw new IllegalStateException("Bean name not set. Could not register " + (BeanDefinition)beanDefinition);
        }
        beanFactory.registerBeanDefinition(this.beanName, (BeanDefinition)beanDefinition);
    }

    public RootBeanDefinition toBeanDefinition() {
        try {
            this.beanDefinition = this.createBeanDefinition();
            return this.beanDefinition;
        }
        catch (Exception ex) {
            throw new FatalBeanException("Failed to create bean definition for bean with name '" + this.beanName + "'", (Throwable)ex);
        }
    }

    private RootBeanDefinition createBeanDefinition() {
        RootBeanDefinition bd = (RootBeanDefinition)this.builder.getBeanDefinition();
        if (this.beanType != null) {
            bd.setTargetType(this.beanType);
        }
        if (this.instanceCreator instanceof Method) {
            bd.setResolvedFactoryMethod((Method)this.instanceCreator);
        }
        this.customizers.forEach(customizer -> customizer.accept(bd));
        return bd;
    }

    private BeanInstanceContext createBeanInstanceContext() {
        String resolvedBeanName = this.beanName != null ? this.beanName : this.createInnerBeanName();
        return new BeanInstanceContext(resolvedBeanName, this.beanClass);
    }

    private String createInnerBeanName() {
        return "(inner bean)#" + ObjectUtils.getIdentityHexString((Object)this.beanDefinition);
    }

    private BeanDefinition resolveBeanDefinition(DefaultListableBeanFactory beanFactory) {
        return this.beanDefinition;
    }

    private static Constructor<?> getConstructor(Class<?> beanType, Class<?> ... parameterTypes) {
        try {
            return beanType.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            String message = String.format("No constructor with type(s) [%s] found on %s", BeanDefinitionRegistrar.toCommaSeparatedNames(parameterTypes), beanType.getName());
            throw new IllegalArgumentException(message, ex);
        }
    }

    private static Method getMethod(Class<?> declaredType, String methodName, Class<?> ... parameterTypes) {
        Method method = ReflectionUtils.findMethod(declaredType, (String)methodName, (Class[])parameterTypes);
        if (method == null) {
            String message = String.format("No method '%s' with type(s) [%s] found on %s", methodName, BeanDefinitionRegistrar.toCommaSeparatedNames(parameterTypes), declaredType.getName());
            throw new IllegalArgumentException(message);
        }
        return AopUtils.selectInvocableMethod((Method)method, declaredType);
    }

    private static String toCommaSeparatedNames(Class<?> ... parameterTypes) {
        return Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(", "));
    }

    public static interface ThrowableSupplier<T>
    extends Supplier<T> {
        public T getWithException() throws Exception;

        @Override
        default public T get() {
            try {
                return this.getWithException();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowableFunction<T, R>
    extends Function<T, R> {
        public R applyWithException(T var1) throws Exception;

        @Override
        default public R apply(T t) {
            try {
                return this.applyWithException(t);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowableConsumer<T>
    extends Consumer<T> {
        public void acceptWithException(T var1) throws Exception;

        @Override
        default public void accept(T t) {
            try {
                this.acceptWithException(t);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    public class BeanInstanceContext {
        private final String beanName;
        private final Class<?> beanType;

        private BeanInstanceContext(String beanName, Class<?> beanType) {
            this.beanName = beanName;
            this.beanType = beanType;
        }

        public <T> T create(DefaultListableBeanFactory beanFactory, ThrowableFunction<InjectedElementAttributes, T> factory) {
            return this.resolveInstanceCreator(BeanDefinitionRegistrar.this.instanceCreator).create(beanFactory, factory);
        }

        private InjectedElementResolver resolveInstanceCreator(Executable instanceCreator) {
            if (instanceCreator instanceof Method) {
                return new InjectedConstructionResolver(instanceCreator, instanceCreator.getDeclaringClass(), this.beanName, x$0 -> BeanDefinitionRegistrar.this.resolveBeanDefinition((DefaultListableBeanFactory)x$0));
            }
            if (instanceCreator instanceof Constructor) {
                return new InjectedConstructionResolver(instanceCreator, this.beanType, this.beanName, x$0 -> BeanDefinitionRegistrar.this.resolveBeanDefinition((DefaultListableBeanFactory)x$0));
            }
            throw new IllegalStateException("No factory method or constructor is set");
        }

        public InjectedElementResolver field(String name, Class<?> type) {
            return new InjectedFieldResolver(this.getField(name, type), this.beanName);
        }

        public InjectedElementResolver method(String name, Class<?> ... parameterTypes) {
            return new InjectedMethodResolver(BeanDefinitionRegistrar.getMethod(this.beanType, name, parameterTypes), this.beanType, this.beanName);
        }

        private Field getField(String fieldName, Class<?> fieldType) {
            Field field = ReflectionUtils.findField(this.beanType, (String)fieldName, fieldType);
            if (field == null) {
                throw new IllegalArgumentException("No field '" + fieldName + "' with type " + fieldType.getName() + " found on " + this.beanType);
            }
            return field;
        }
    }
}

