/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot;

import java.lang.reflect.InvocationTargetException;
import org.springframework.boot.ApplicationContextFactory;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;

public class SpringApplicationAotUtils {
    public static ApplicationContextFactory AOT_FACTORY = webApplicationType -> {
        try {
            switch (webApplicationType) {
                case SERVLET: {
                    return new ServletWebServerApplicationContext();
                }
                case REACTIVE: {
                    return new ReactiveWebServerApplicationContext();
                }
            }
            return new GenericApplicationContext();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable create an AOT ApplicationContext instance, you may need a custom ApplicationContextFactory", ex);
        }
    };

    public static ApplicationContextInitializer<?> getBootstrapInitializer() {
        try {
            return (ApplicationContextInitializer)Class.forName("org.springframework.aot.ContextBootstrapInitializer").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

