/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.implementation.bind.annotation.Pipe;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.BuildTimeProxyDescriptor;
import org.springframework.aop.framework.Interceptors;
import org.springframework.aop.framework.ProxyConfiguration;
import org.springframework.aop.framework._AdvisedSupportAware;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class ProxyGenerator {
    protected static final Log logger = LogFactory.getLog(ProxyGenerator.class);
    private static final Map<Class<?>, Boolean> validatedClasses = new WeakHashMap();

    public static DynamicType.Unloaded<?> getProxyBytes(BuildTimeProxyDescriptor cpd, ClassLoader classLoader) {
        ProxyConfiguration config = ProxyConfiguration.get(cpd, classLoader);
        logger.info((Object)("Generating class file bytes for a proxy named " + config.getProxyClassName()));
        try {
            String targetClass = config.getTargetClass();
            Class proxySuperClass = ClassUtils.forName((String)targetClass, (ClassLoader)classLoader);
            if (Modifier.isFinal(proxySuperClass.getModifiers())) {
                throw new IllegalStateException("Cannot create a build time proxy for a final class: " + targetClass);
            }
            ProxyGenerator.validateClassIfNecessary(proxySuperClass, classLoader);
            Class<?> target = ProxyGenerator.resolve(targetClass, classLoader);
            ByteBuddy byteBuddy = new ByteBuddy(ClassFileVersion.of(target)).with(TypeValidation.DISABLED);
            byteBuddy = byteBuddy.ignore((ElementMatcher)ElementMatchers.none());
            byteBuddy = byteBuddy.with((NamingStrategy)new ProxyNamingStrategy(config));
            byteBuddy = byteBuddy.with((AuxiliaryType.NamingStrategy)new AuxiliaryTypeNamingStrategy());
            DynamicType.Builder.FieldDefinition.Optional.Valuable builder = byteBuddy.subclass(target);
            builder = builder.implement((Type[])ProxyGenerator.resolve(config.getProxiedInterfaces(), classLoader));
            builder = ProxyGenerator.configure(builder, proxySuperClass, config, classLoader);
            builder = builder.defineField("advised", AdvisedSupport.class, new ModifierContributor.ForField[]{Visibility.PRIVATE});
            builder = builder.implement(new Type[]{_AdvisedSupportAware.class}).method((ElementMatcher)ElementMatchers.named((String)"_setAdvised").or((ElementMatcher)ElementMatchers.named((String)"_getAdvised"))).intercept((Implementation)FieldAccessor.ofField((String)"advised"));
            DynamicType.Unloaded type = builder.make();
            return type;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Problem creating proxy with configuration: " + config, ex);
        }
    }

    public static ProxyConfiguration getConfig(AdvisedSupport advised, ClassLoader classLoader) {
        ProxyConfiguration configuration = ProxyConfiguration.get(advised, classLoader);
        return configuration;
    }

    public static Class<?>[] resolve(List<String> types, ClassLoader classLoader) {
        Class[] result = new Class[types.size()];
        for (int i = 0; i < types.size(); ++i) {
            result[i] = ProxyGenerator.resolve(types.get(i), classLoader);
        }
        return result;
    }

    public static Class<?> resolve(String type, ClassLoader classLoader) {
        return ClassUtils.resolveClassName((String)type, (ClassLoader)classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateClassIfNecessary(Class<?> proxySuperClass, @Nullable ClassLoader proxyClassLoader) {
        if (logger.isInfoEnabled()) {
            Map<Class<?>, Boolean> map = validatedClasses;
            synchronized (map) {
                if (!validatedClasses.containsKey(proxySuperClass)) {
                    ProxyGenerator.doValidateClass(proxySuperClass, proxyClassLoader);
                    validatedClasses.put(proxySuperClass, Boolean.TRUE);
                }
            }
        }
    }

    private static void doValidateClass(Class<?> proxySuperClass, @Nullable ClassLoader proxyClassLoader) {
        if (Object.class != proxySuperClass) {
            Method[] methods;
            for (Method method : methods = proxySuperClass.getDeclaredMethods()) {
                int mod = method.getModifiers();
                if (Modifier.isStatic(mod)) continue;
                if (Modifier.isFinal(mod)) {
                    logger.info((Object)("Unable to proxy method [" + method + "] because it is final: All calls to this method via a proxy will NOT be routed to the target instance."));
                    continue;
                }
                if (Modifier.isPublic(mod) || Modifier.isProtected(mod) || Modifier.isPrivate(mod) || proxyClassLoader == null || proxySuperClass.getClassLoader() == proxyClassLoader) continue;
                logger.info((Object)("Unable to proxy method [" + method + "] because it is package-visible across different ClassLoaders: All calls to this method via a proxy will NOT be routed to the target instance."));
            }
            if (proxySuperClass.getSuperclass() != null) {
                ProxyGenerator.doValidateClass(proxySuperClass.getSuperclass(), proxyClassLoader);
            }
        }
    }

    protected static DynamicType.Builder<?> configure(DynamicType.Builder<?> builder, Class<?> rootClass, ProxyConfiguration config, ClassLoader classLoader) throws Exception {
        Class<?> targetClass = ProxyGenerator.resolve(config.getTargetClass(), classLoader);
        MethodDelegation.WithCustomProperties invokeConfiguration = MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{Pipe.Binder.install(Function.class)});
        MethodDelegation invokeTarget = config.isExposeProxy() ? invokeConfiguration.to(config.isStatic() ? Interceptors.StaticUnadvisedExposedInterceptor.class : Interceptors.DynamicUnadvisedExposedInterceptor.class) : invokeConfiguration.to(config.isStatic() ? Interceptors.StaticUnadvisedInterceptor.class : Interceptors.DynamicUnadvisedInterceptor.class);
        MethodDelegation aopProxy = MethodDelegation.to(Interceptors.DynamicAdvisedInterceptor.class);
        MethodCall adviceDispatched = MethodCall.invokeSelf().onField("advised").withAllArguments();
        SuperMethodCall dispatchTarget = config.isStatic() ? MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{Pipe.Binder.install(Function.class)}).to(Interceptors.ForwardingInterceptor.class) : SuperMethodCall.INSTANCE;
        builder = builder.ignoreAlso(target -> {
            if (ElementMatchers.isFinalizer().matches(target)) {
                logger.debug((Object)"Found finalize() method - using NO_OVERRIDE");
                return true;
            }
            return false;
        });
        builder = builder.method(target -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Method " + target + "has return type that is assignable from the target type (may return this) - using INVOKE_TARGET"));
            }
            return true;
        }).intercept((Implementation)invokeTarget);
        builder = builder.method(target -> {
            TypeDescription returnType = target.getReturnType().asErasure();
            if (returnType.isPrimitive() || !returnType.isAssignableFrom(targetClass)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Method " + target + " has return type that ensures this cannot be returned- using DISPATCH_TARGET"));
                }
                return true;
            }
            return false;
        }).intercept((Implementation)dispatchTarget);
        builder = builder.method(target -> {
            TypeDescription returnType = target.getReturnType().asErasure();
            if (returnType.represents((Type)targetClass)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Method " + target + "has return type same as target type (may return this) - using INVOKE_TARGET"));
                }
                return true;
            }
            return false;
        }).intercept((Implementation)invokeTarget);
        builder = builder.method(target -> config.isExposeProxy() || !config.isStatic()).intercept((Implementation)invokeTarget);
        builder = builder.method(target -> true).intercept((Implementation)aopProxy);
        builder = builder.method(target -> {
            if (config.isExposeProxy()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Must expose proxy on advised method: " + target));
                }
                return true;
            }
            return false;
        }).intercept((Implementation)aopProxy);
        builder = builder.method(target -> {
            if (ElementMatchers.isHashCode().matches(target)) {
                logger.debug((Object)("Found 'hashCode' method: " + target));
                return true;
            }
            return false;
        }).intercept((Implementation)MethodDelegation.to(Interceptors.HashCodeInterceptor.class));
        builder = builder.method(target -> {
            if (ElementMatchers.isEquals().matches(target)) {
                logger.debug((Object)("Found 'equals' method: " + target));
                return true;
            }
            return false;
        }).intercept((Implementation)MethodDelegation.to(Interceptors.EqualsInterceptor.class));
        builder = builder.method(target -> {
            if (!config.isOpaque() && target.getDeclaringType().isInterface() && target.getDeclaringType().asErasure().isAssignableFrom(Advised.class)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Method is declared on Advised interface: " + target));
                }
                return true;
            }
            return false;
        }).intercept((Implementation)adviceDispatched);
        return builder;
    }

    private static class AuxiliaryTypeNamingStrategy
    implements AuxiliaryType.NamingStrategy {
        private int counter = 1;

        public String name(TypeDescription instrumentedType) {
            return instrumentedType.getName() + "$aux$" + Integer.toHexString(this.counter++);
        }
    }

    private static class ProxyNamingStrategy
    extends NamingStrategy.AbstractBase {
        private final ProxyConfiguration config;

        ProxyNamingStrategy(ProxyConfiguration config) {
            this.config = config;
        }

        protected String name(TypeDescription superClass) {
            return this.config.getProxyClassName();
        }
    }
}

