/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Argument;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.Pipe;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.springframework.aop.AopInvocationException;
import org.springframework.aop.RawTargetAccess;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopContext;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.aop.framework._AdvisedSupportAware;
import org.springframework.lang.Nullable;

public class Interceptors {
    public static final String ADVISED = "advised";

    @Nullable
    private static Object processReturnType(Object proxy, @Nullable Object target, Method method, @Nullable Object returnValue) {
        if (returnValue != null && returnValue == target && !RawTargetAccess.class.isAssignableFrom(method.getDeclaringClass())) {
            returnValue = proxy;
        }
        Class<?> returnType = method.getReturnType();
        if (returnValue == null && returnType != Void.TYPE && returnType.isPrimitive()) {
            throw new AopInvocationException("Null return value from advice does not match primitive return type for: " + method);
        }
        return returnValue;
    }

    private static class OptimizedReflectiveMethodInvocation
    extends ReflectiveMethodInvocation {
        private final boolean publicMethod;

        public OptimizedReflectiveMethodInvocation(Object proxy, Object target, Method method, Object[] arguments, Class<?> targetClass, List<Object> interceptorsAndDynamicMethodMatchers) {
            super(proxy, target, method, arguments, targetClass, interceptorsAndDynamicMethodMatchers);
            this.publicMethod = Modifier.isPublic(method.getModifiers());
        }

        protected Object invokeJoinpoint() throws Throwable {
            return super.invokeJoinpoint();
        }
    }

    public static class FixedChainStaticTargetInterceptor
    implements Serializable {
        private final List<Object> adviceChain;

        public FixedChainStaticTargetInterceptor(List<Object> adviceChain) {
            this.adviceChain = adviceChain;
        }

        @Nullable
        @RuntimeType
        public Object intercept(@Nullable @FieldValue(value="advised") AdvisedSupport advised, @This Object proxy, @Origin Method method, @AllArguments Object[] args, @Nullable @SuperCall(nullIfImpossible=true) Callable<?> superCall) throws Throwable {
            if (advised == null) {
                if (superCall == null) {
                    throw new AbstractMethodError();
                }
                return superCall.call();
            }
            Object target = advised.getTargetSource().getTarget();
            OptimizedReflectiveMethodInvocation invocation = new OptimizedReflectiveMethodInvocation(proxy, target, method, args, advised.getTargetClass(), this.adviceChain);
            Object returnValue = invocation.proceed();
            returnValue = Interceptors.processReturnType(proxy, target, method, returnValue);
            return returnValue;
        }
    }

    public static class HashCodeInterceptor {
        @Nullable
        @RuntimeType
        public static Object intercept(@Nullable @FieldValue(value="advised") AdvisedSupport advised, @Nullable @SuperCall(nullIfImpossible=true) Callable<?> superCall) throws Throwable {
            if (advised == null) {
                if (superCall == null) {
                    throw new AbstractMethodError();
                }
                return superCall.call();
            }
            return Interceptors.class.hashCode() * 13 + advised.getTargetSource().hashCode();
        }
    }

    public static class EqualsInterceptor {
        @Nullable
        @RuntimeType
        public static Object intercept(@Nullable @FieldValue(value="advised") AdvisedSupport advised, @This Object proxy, @Nullable @Argument(value=0) Object other, @Nullable @SuperCall(nullIfImpossible=true) Callable<?> superCall) throws Throwable {
            if (advised == null) {
                if (superCall == null) {
                    throw new AbstractMethodError();
                }
                return superCall.call();
            }
            if (proxy == other) {
                return true;
            }
            if (other instanceof _AdvisedSupportAware) {
                AdvisedSupport otherAdvised = ((_AdvisedSupportAware)other)._getAdvised();
                return AopProxyUtils.equalsInProxy((AdvisedSupport)advised, (AdvisedSupport)otherAdvised);
            }
            return false;
        }
    }

    public static class ForwardingInterceptor {
        @Nullable
        @RuntimeType
        public static Object intercept(@Nullable @FieldValue(value="advised") AdvisedSupport advised, @Pipe Function<Object, ?> forward, @Nullable @SuperCall(nullIfImpossible=true) Callable<?> superCall) throws Throwable {
            if (advised == null) {
                if (superCall == null) {
                    throw new AbstractMethodError();
                }
                return superCall.call();
            }
            return forward.apply(advised.getTargetSource().getTarget());
        }
    }

    public static class DynamicUnadvisedExposedInterceptor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @RuntimeType
        public static Object intercept(@Nullable @FieldValue(value="advised") AdvisedSupport advised, @This Object proxy, @Origin Method method, @Pipe Function<Object, ?> forward, @Nullable @SuperCall(nullIfImpossible=true) Callable<?> superCall) throws Throwable {
            if (advised == null) {
                if (superCall == null) {
                    throw new AbstractMethodError();
                }
                return superCall.call();
            }
            TargetSource targetSource = advised.getTargetSource();
            Object oldProxy = null;
            Object target = targetSource.getTarget();
            try {
                oldProxy = AopContext.setCurrentProxy((Object)proxy);
                Object returnValue = forward.apply(target);
                Object object = Interceptors.processReturnType(proxy, target, method, returnValue);
                return object;
            }
            finally {
                AopContext.setCurrentProxy((Object)oldProxy);
                targetSource.releaseTarget(target);
            }
        }
    }

    public static class DynamicUnadvisedInterceptor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @RuntimeType
        public static Object intercept(@Nullable @FieldValue(value="advised") AdvisedSupport advised, @This Object proxy, @Origin Method method, @Pipe Function<Object, ?> forward, @Nullable @SuperCall(nullIfImpossible=true) Callable<?> superCall) throws Throwable {
            if (advised == null) {
                if (superCall == null) {
                    throw new AbstractMethodError();
                }
                return superCall.call();
            }
            TargetSource targetSource = advised.getTargetSource();
            Object target = targetSource.getTarget();
            try {
                Object returnValue = forward.apply(target);
                Object object = Interceptors.processReturnType(proxy, target, method, returnValue);
                return object;
            }
            finally {
                targetSource.releaseTarget(target);
            }
        }
    }

    public static class StaticUnadvisedExposedInterceptor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @RuntimeType
        public static Object intercept(@Nullable @FieldValue(value="advised") AdvisedSupport advised, @This Object proxy, @Origin Method method, @Pipe Function<Object, ?> forward, @Nullable @SuperCall(nullIfImpossible=true) Callable<?> superCall) throws Throwable {
            if (advised == null) {
                if (superCall == null) {
                    throw new AbstractMethodError();
                }
                return superCall.call();
            }
            Object target = advised.getTargetSource().getTarget();
            Object oldProxy = null;
            try {
                oldProxy = AopContext.setCurrentProxy((Object)proxy);
                Object returnValue = forward.apply(target);
                Object object = Interceptors.processReturnType(proxy, target, method, returnValue);
                return object;
            }
            finally {
                AopContext.setCurrentProxy((Object)oldProxy);
            }
        }
    }

    public static class DynamicAdvisedInterceptor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @RuntimeType
        public static Object intercept(@Nullable @FieldValue(value="advised") AdvisedSupport advised, @This Object proxy, @Origin Method method, @AllArguments Object[] args, @Nullable @SuperCall(nullIfImpossible=true) Callable<?> superCall) throws Throwable {
            if (advised == null) {
                if (superCall == null) {
                    throw new AbstractMethodError();
                }
                return superCall.call();
            }
            Object oldProxy = null;
            boolean setProxyContext = false;
            Class<?> targetClass = null;
            Object target = null;
            try {
                Object returnValue;
                if (advised.exposeProxy) {
                    oldProxy = AopContext.setCurrentProxy((Object)proxy);
                    setProxyContext = true;
                }
                if ((target = advised.getTargetSource().getTarget()) != null) {
                    targetClass = target.getClass();
                }
                List chain = advised.getInterceptorsAndDynamicInterceptionAdvice(method, targetClass);
                try {
                    returnValue = new OptimizedReflectiveMethodInvocation(proxy, target, method, args, targetClass, chain).proceed();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof RuntimeException || throwable instanceof Error) {
                        throw throwable;
                    }
                    for (Class<?> exceptionType : method.getExceptionTypes()) {
                        if (!exceptionType.isInstance(throwable)) continue;
                        throw throwable;
                    }
                    throw new UndeclaredThrowableException(throwable);
                }
                Object object = returnValue = Interceptors.processReturnType(proxy, target, method, returnValue);
                return object;
            }
            finally {
                if (target != null) {
                    advised.getTargetSource().releaseTarget(target);
                }
                if (setProxyContext) {
                    AopContext.setCurrentProxy((Object)oldProxy);
                }
            }
        }
    }

    public static class StaticUnadvisedInterceptor {
        @Nullable
        @RuntimeType
        public static Object intercept(@Nullable @FieldValue(value="advised") AdvisedSupport advised, @This Object proxy, @Origin Method method, @Pipe Function<Object, ?> forward, @Nullable @SuperCall(nullIfImpossible=true) Callable<?> superCall) throws Throwable {
            if (advised == null) {
                if (superCall == null) {
                    throw new AbstractMethodError();
                }
                return superCall.call();
            }
            Object target = advised.getTargetSource().getTarget();
            Object returnValue = forward.apply(target);
            return Interceptors.processReturnType(proxy, target, method, returnValue);
        }
    }
}

