/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex.substitutions.data;

import com.mongodb.DBRef;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.core.convert.DbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.DbRefResolverCallback;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.nativex.substitutions.OnlyIfPresent;
import org.springframework.nativex.substitutions.data.OnlyIfImperativeMongoClient;

@TargetClass(className="org.springframework.data.mongodb.core.convert.DefaultDbRefResolver", onlyWith={OnlyIfPresent.class, OnlyIfImperativeMongoClient.class})
public final class Target_DefaultDbRefResolver {
    @Alias
    private PersistenceExceptionTranslator exceptionTranslator = null;

    @Substitute
    private Object createLazyLoadingProxy(MongoPersistentProperty property, @Nullable DBRef dbref, DbRefResolverCallback callback, DbRefProxyHandler handler) {
        Class propertyType = property.getType();
        LazyLoadingInterceptor interceptor = new LazyLoadingInterceptor(property, dbref, this.exceptionTranslator, callback);
        if (!propertyType.isInterface()) {
            ProxyFactory factory = new ProxyFactory();
            factory.addAdvice((Advice)interceptor);
            factory.addInterface(LazyLoadingProxy.class);
            factory.setTargetClass(propertyType);
            factory.setProxyTargetClass(true);
            return factory.getProxy(propertyType.getClassLoader());
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        for (Class<?> type : propertyType.getInterfaces()) {
            proxyFactory.addInterface(type);
        }
        proxyFactory.addInterface(LazyLoadingProxy.class);
        proxyFactory.addInterface(propertyType);
        proxyFactory.addAdvice((Advice)interceptor);
        return handler.populateId(property, dbref, proxyFactory.getProxy(LazyLoadingProxy.class.getClassLoader()));
    }

    @TargetClass(className="org.springframework.data.mongodb.core.convert.DefaultDbRefResolver", innerClass={"LazyLoadingInterceptor"}, onlyWith={OnlyIfPresent.class, OnlyIfImperativeMongoClient.class})
    static final class LazyLoadingInterceptor
    implements org.aopalliance.intercept.MethodInterceptor,
    MethodInterceptor,
    Serializable {
        @Alias
        public LazyLoadingInterceptor(MongoPersistentProperty property, @Nullable DBRef dbref, PersistenceExceptionTranslator exceptionTranslator, DbRefResolverCallback callback) {
        }

        @Alias
        public Object invoke(MethodInvocation invocation) throws Throwable {
            return null;
        }

        @Alias
        public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
            return null;
        }
    }
}

