/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex;

import org.springframework.core.NativeDetector;
import org.springframework.nativex.GeneratedClassNotFoundException;
import org.springframework.util.ClassUtils;

public abstract class AotModeDetector {
    private static final boolean AOT_MODE_PROPERTY = System.getProperty("springAot") != null;
    private static final String GENERATED_CLASS = "org.springframework.aot.StaticSpringFactories";
    private static final boolean generatedClassPresent = ClassUtils.isPresent((String)"org.springframework.aot.StaticSpringFactories", null);

    public static boolean isAotModeEnabled() {
        if (AOT_MODE_PROPERTY || NativeDetector.inNativeImage()) {
            if (!generatedClassPresent) {
                throw new GeneratedClassNotFoundException(GENERATED_CLASS);
            }
            return true;
        }
        return false;
    }

    protected static boolean isMain(Thread thread) {
        return thread.getName().equals("main") && thread.getContextClassLoader().getClass().getName().contains("AppClassLoader");
    }
}

