/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.reflect.Proxy;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.JdkDynamicAopProxy;
import org.springframework.aop.framework.ObjenesisBuildTimeAopProxy;
import org.springframework.nativex.substitutions.OnlyIfPresent;

@TargetClass(className="org.springframework.aop.framework.DefaultAopProxyFactory", onlyWith={OnlyIfPresent.class})
final class Target_DefaultAopProxyFactory {
    Target_DefaultAopProxyFactory() {
    }

    @Substitute
    public AopProxy createAopProxy(AdvisedSupport config) throws AopConfigException {
        if (config.isOptimize() || config.isProxyTargetClass() || this.hasNoUserSuppliedProxyInterfaces(config)) {
            Class targetClass = config.getTargetClass();
            if (targetClass == null) {
                throw new AopConfigException("TargetSource cannot determine target class: Either an interface or a target is required for proxy creation.");
            }
            if (targetClass.isInterface() || Proxy.isProxyClass(targetClass)) {
                return new JdkDynamicAopProxy(config);
            }
            return new ObjenesisBuildTimeAopProxy(config);
        }
        return new JdkDynamicAopProxy(config);
    }

    @Alias
    private boolean hasNoUserSuppliedProxyInterfaces(AdvisedSupport config) {
        return true;
    }
}

