/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.AopInvocationException;
import org.springframework.aop.RawTargetAccess;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ProxyConfiguration;
import org.springframework.aop.framework._AdvisedSupportAware;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BuildTimeAopProxy
implements AopProxy,
Serializable {
    protected static final Log logger = LogFactory.getLog(BuildTimeAopProxy.class);
    private static final Map<Object, Class<?>> cache = new ConcurrentHashMap();
    private static final Map<Class<?>, Boolean> validatedClasses = new WeakHashMap();
    protected final AdvisedSupport advised;
    @Nullable
    protected Object[] constructorArgs;
    @Nullable
    protected Class<?>[] constructorArgTypes;

    public BuildTimeAopProxy(AdvisedSupport config) throws AopConfigException {
        Assert.notNull((Object)config, (String)"AdvisedSupport must not be null");
        if (config.getAdvisors().length == 0 && config.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("No advisors and no TargetSource specified");
        }
        this.advised = config;
    }

    public void setConstructorArguments(@Nullable Object[] constructorArgs, @Nullable Class<?>[] constructorArgTypes) {
        if (constructorArgs == null || constructorArgTypes == null) {
            throw new IllegalArgumentException("Both 'constructorArgs' and 'constructorArgTypes' need to be specified");
        }
        if (constructorArgs.length != constructorArgTypes.length) {
            throw new IllegalArgumentException("Number of 'constructorArgs' (" + constructorArgs.length + ") must match number of 'constructorArgTypes' (" + constructorArgTypes.length + ")");
        }
        this.constructorArgs = constructorArgs;
        this.constructorArgTypes = constructorArgTypes;
    }

    public Object getProxy() {
        return this.getProxy(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProxy(@Nullable ClassLoader classLoader) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating Build Time Proxy: target source is " + this.advised.getTargetSource()));
        }
        try {
            ProxyConfiguration configuration;
            Class<?> proxyType;
            ClassLoader targetClassLoader;
            Class rootClass = this.advised.getTargetClass();
            Assert.state((rootClass != null ? 1 : 0) != 0, (String)"Target class must be available for creating a Build Time Proxy");
            Class proxySuperClass = rootClass;
            if (rootClass.getName().contains("$$")) {
                Class<?>[] additionalInterfaces;
                proxySuperClass = rootClass.getSuperclass();
                for (Class<?> additionalInterface : additionalInterfaces = rootClass.getInterfaces()) {
                    if (additionalInterface == _AdvisedSupportAware.class) continue;
                    this.advised.addInterface(additionalInterface);
                }
            }
            this.validateClassIfNecessary(proxySuperClass, classLoader);
            if (classLoader == null) {
                targetClassLoader = proxySuperClass.getClassLoader();
                if (targetClassLoader == null) {
                    targetClassLoader = this.getClass().getClassLoader();
                }
            } else {
                targetClassLoader = classLoader;
            }
            if ((proxyType = cache.get(configuration = ProxyConfiguration.get(this.advised, targetClassLoader))) == null) {
                Map<Object, Class<?>> map = cache;
                synchronized (map) {
                    proxyType = cache.get(configuration);
                    if (proxyType == null) {
                        proxyType = BuildTimeAopProxy.attemptToLoadProxyClass(configuration, targetClassLoader);
                        if (proxyType == null) {
                            throw new IllegalStateException("Class proxy missing at runtime, hint required at build time: " + configuration.asHint());
                        }
                        cache.put(configuration, proxyType);
                    }
                }
            }
            Object proxy = this.createProxyInstance(proxyType);
            ((_AdvisedSupportAware)proxy)._setAdvised(this.advised);
            return proxy;
        }
        catch (IllegalStateException ex) {
            throw new AopConfigException("Unexpected problem loading and instantiating proxy for target class " + this.advised.getTargetClass(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new AopConfigException("Unexpected AOP exception", (Throwable)ex);
        }
    }

    private static Class<?> attemptToLoadProxyClass(ProxyConfiguration configuration, ClassLoader classLoader) {
        logger.info((Object)("Attempting discovery (load) of build time generated proxy for class: " + configuration.getTargetClass()));
        String proxyClassName = configuration.getProxyClassName();
        try {
            Class proxyClass = ClassUtils.resolveClassName((String)proxyClassName, (ClassLoader)classLoader);
            logger.info((Object)("Suitable proxy found with name " + proxyClassName));
            return proxyClass;
        }
        catch (Throwable t) {
            logger.info((Object)("No suitable proxy found with name " + proxyClassName));
            return null;
        }
    }

    protected Object createProxyInstance(Class<?> proxyClass) throws Exception {
        return this.constructorArgs != null ? proxyClass.getDeclaredConstructor(this.constructorArgTypes).newInstance(this.constructorArgs) : proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateClassIfNecessary(Class<?> proxySuperClass, @Nullable ClassLoader proxyClassLoader) {
        if (logger.isInfoEnabled()) {
            Map<Class<?>, Boolean> map = validatedClasses;
            synchronized (map) {
                if (!validatedClasses.containsKey(proxySuperClass)) {
                    this.doValidateClass(proxySuperClass, proxyClassLoader);
                    validatedClasses.put(proxySuperClass, Boolean.TRUE);
                }
            }
        }
    }

    private void doValidateClass(Class<?> proxySuperClass, @Nullable ClassLoader proxyClassLoader) {
        if (Object.class != proxySuperClass) {
            Method[] methods;
            for (Method method : methods = proxySuperClass.getDeclaredMethods()) {
                int mod = method.getModifiers();
                if (Modifier.isStatic(mod)) continue;
                if (Modifier.isFinal(mod)) {
                    logger.info((Object)("Unable to proxy method [" + method + "] because it is final: All calls to this method via a proxy will NOT be routed to the target instance."));
                    continue;
                }
                if (Modifier.isPublic(mod) || Modifier.isProtected(mod) || Modifier.isPrivate(mod) || proxyClassLoader == null || proxySuperClass.getClassLoader() == proxyClassLoader) continue;
                logger.info((Object)("Unable to proxy method [" + method + "] because it is package-visible across different ClassLoaders: All calls to this method via a proxy will NOT be routed to the target instance."));
            }
            this.doValidateClass(proxySuperClass.getSuperclass(), proxyClassLoader);
        }
    }

    @Nullable
    private static Object processReturnType(Object proxy, @Nullable Object target, Method method, @Nullable Object returnValue) {
        if (returnValue != null && returnValue == target && !RawTargetAccess.class.isAssignableFrom(method.getDeclaringClass())) {
            returnValue = proxy;
        }
        Class<?> returnType = method.getReturnType();
        if (returnValue == null && returnType != Void.TYPE && returnType.isPrimitive()) {
            throw new AopInvocationException("Null return value from advice does not match primitive return type for: " + method);
        }
        return returnValue;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof BuildTimeAopProxy && AopProxyUtils.equalsInProxy((AdvisedSupport)this.advised, (AdvisedSupport)((BuildTimeAopProxy)other).advised);
    }

    public int hashCode() {
        return BuildTimeAopProxy.class.hashCode() * 13 + this.advised.getTargetSource().hashCode();
    }
}

