/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.nativex.type.ComponentProcessor;
import org.springframework.nativex.type.Field;
import org.springframework.nativex.type.Method;
import org.springframework.nativex.type.NativeContext;
import org.springframework.nativex.type.Type;

public class WebComponentProcessor
implements ComponentProcessor {
    private Set<String> added = new HashSet<String>();

    public boolean handle(NativeContext imageContext, String componentType, List<String> classifiers) {
        Type resolvedComponentType = imageContext.getTypeSystem().resolveDotted(componentType, true);
        return resolvedComponentType != null && resolvedComponentType.isAtController();
    }

    public void process(NativeContext imageContext, String componentType, List<String> classifiers) {
        Type controllerType = imageContext.getTypeSystem().resolveDotted(componentType, true);
        List mappings = controllerType.getMethods(m -> m.isAtMapping());
        imageContext.log("WebComponentProcessor: in controller " + componentType + " processing mappings " + mappings);
        for (Method mapping : mappings) {
            ArrayList<Type> toProcess = new ArrayList<Type>();
            toProcess.addAll(mapping.getParameterTypes());
            toProcess.add(mapping.getReturnType());
            for (Type type : toProcess) {
                String typename;
                if (type == null || (typename = type.getDottedName()).startsWith("java.") || typename.startsWith("org.springframework.ui.") || typename.startsWith("org.springframework.validation.") || !this.added.add(typename)) continue;
                Set added = imageContext.addReflectiveAccessHierarchy(typename, 14);
                this.analyze(imageContext, type, added);
                imageContext.log("WebComponentProcessor: adding reflective access to " + added + " (whilst introspecting controller " + componentType + ")");
            }
        }
    }

    private void analyze(NativeContext imageContext, Type type, Set<String> added) {
        List fields = type.getFields();
        for (Field field : fields) {
            Set fieldTypenames = field.getTypesInSignature();
            for (String fieldTypename : fieldTypenames) {
                String dottedFieldTypename;
                if (fieldTypename == null || this.ignore(dottedFieldTypename = fieldTypename.replace("/", ".")) || !added.add(dottedFieldTypename)) continue;
                added.addAll(imageContext.addReflectiveAccessHierarchy(dottedFieldTypename, 14));
                this.analyze(imageContext, imageContext.getTypeSystem().resolveDotted(dottedFieldTypename, true), added);
            }
        }
    }

    private boolean ignore(String name) {
        return name.startsWith("java.") || name.startsWith("org.springframework.ui.") || name.startsWith("org.springframework.validation.");
    }
}

