/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.nativex.type.SpringFactoriesProcessor;

public class ActuatorMetricsEliminator
implements SpringFactoriesProcessor {
    private static Log logger = LogFactory.getLog(ActuatorMetricsEliminator.class);
    private static final boolean active;

    public boolean filter(String key, List<String> values) {
        if (!active) {
            return false;
        }
        if (key.equals("org.springframework.boot.autoconfigure.EnableAutoConfiguration")) {
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String value : values) {
                if (!value.startsWith("org.springframework.boot.actuate.autoconfigure.metrics.")) continue;
                toRemove.add(value);
            }
            if (toRemove.size() > 0) {
                logger.debug((Object)("ActuatorMetricsEliminator: removing " + toRemove.size() + " configurations from " + "org.springframework.boot.autoconfigure.EnableAutoConfiguration"));
                values.removeAll(toRemove);
                return true;
            }
        }
        return false;
    }

    static {
        String value = System.getProperty("spring.native.factories.no-actuator-metrics", "false");
        active = value.equalsIgnoreCase("true");
        if (active) {
            logger.debug((Object)"ActuatorMetricsEliminator: active");
        }
    }
}

