/*
 * Decompiled with CFR 0.152.
 */
package org.springframework;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.nativex.hint.Flag;
import org.springframework.nativex.type.ComponentProcessor;
import org.springframework.nativex.type.Field;
import org.springframework.nativex.type.Method;
import org.springframework.nativex.type.NativeContext;
import org.springframework.nativex.type.Type;

public class SpringAtRepositoryComponentProcessor
implements ComponentProcessor {
    private static final String LOG_PREFIX = "SARCP: ";

    public boolean handle(NativeContext imageContext, String key, List<String> values) {
        Type resolvedKey = imageContext.getTypeSystem().resolveDotted(key);
        if (resolvedKey.hasAnnotationInHierarchy("Lorg/springframework/stereotype/Repository;")) {
            imageContext.log("SARCP: handling @Repository " + key);
            return true;
        }
        return false;
    }

    public void process(NativeContext imageContext, String key, List<String> values) {
        try {
            Type repositoryType = imageContext.getTypeSystem().resolveDotted(key);
            HashSet<String> processed = new HashSet<String>();
            this.processRepositoryType(repositoryType, imageContext, processed);
            this.registerRepositoryProxy(imageContext, repositoryType, processed);
        }
        catch (Throwable t) {
            imageContext.log("SARCP: WARNING: Problem with SpringAtRepositoryComponentProcessor: " + t.getMessage());
            t.printStackTrace();
        }
    }

    public void processRepositoryType(Type repositoryType, NativeContext imageContext, Set<String> processed) {
        Type[] repositoryInterfaces;
        for (Type repositoryInterface : repositoryInterfaces = repositoryType.getInterfaces()) {
            this.addAllTypesFromSignaturesInRepositoryInterface(repositoryInterface, imageContext, processed);
        }
        imageContext.log(String.format("SARCP: %s reflective access added - adding this repository type and its hierarchy", repositoryType.getDottedName()));
        imageContext.addReflectiveAccessHierarchy(repositoryType, 54);
    }

    public void addAllTypesFromSignaturesInRepositoryInterface(Type repositoryInterface, NativeContext imageContext, Set<String> processed) {
        boolean addValidationMessagesBundle = false;
        List publicRepositoryMethods = repositoryInterface.getMethods(m -> m.isPublic());
        for (Method publicRepositoryMethod : publicRepositoryMethods) {
            Set types = publicRepositoryMethod.getSignatureTypes(true);
            for (Type type : types) {
                if (type == null || !processed.add(type.getDottedName()) || !this.inSimilarPackage(type, repositoryInterface)) continue;
                imageContext.log(String.format("SARCP: %s reflective access added - due to method %s.%s", type.getDottedName(), repositoryInterface.getDottedName(), publicRepositoryMethod.toString()));
                ArrayList<Flag> flags = new ArrayList<Flag>();
                flags.add(Flag.allPublicMethods);
                flags.add(Flag.allDeclaredConstructors);
                if (type.hasAnnotatedField(null)) {
                    addValidationMessagesBundle = true;
                    flags.add(Flag.allDeclaredFields);
                }
                imageContext.addReflectiveAccess(type.getDottedName(), flags.toArray(new Flag[0]));
                this.processPossibleDomainType(type, imageContext, processed);
            }
        }
        if (repositoryInterface.getName().endsWith("Repository")) {
            String pluralName = repositoryInterface.getDottedName();
            pluralName = pluralName.substring(0, pluralName.length() - "Repository".length());
            if (processed.add(pluralName = pluralName + "s")) {
                Type resolvedPluralType = imageContext.getTypeSystem().resolveDotted(pluralName, true);
                if (resolvedPluralType != null) {
                    imageContext.log(String.format("SARCP: %s reflective access added - found as a plural form of %s", pluralName, repositoryInterface.getDottedName()));
                    imageContext.addReflectiveAccess(pluralName, new Flag[]{Flag.allPublicMethods, Flag.allDeclaredConstructors});
                } else {
                    imageContext.log(String.format("SARCP: %s PLURAL TYPE NOT FOUND", pluralName));
                }
            }
        }
        if (addValidationMessagesBundle) {
            imageContext.addResourceBundle("org.hibernate.validator.ValidationMessages");
        }
    }

    private void processPossibleDomainType(Type type, NativeContext imageContext, Set<String> processed) {
        List fields = type.getFields();
        for (Field field : fields) {
            Set fieldTypes = field.getTypesInSignature();
            for (String fieldType : fieldTypes) {
                Type resolvedFieldType;
                if (!processed.add(fieldType) || (resolvedFieldType = imageContext.getTypeSystem().resolveSlashed(fieldType, true)) == null || !this.inSimilarPackage(resolvedFieldType, type)) continue;
                imageContext.log(String.format("SARCP: %s reflective access added - due to field %s.%s", resolvedFieldType.getDottedName(), type.getDottedName(), field.getName()));
                imageContext.addReflectiveAccess(resolvedFieldType.getDottedName(), new Flag[]{Flag.allPublicMethods, Flag.allDeclaredConstructors});
            }
        }
    }

    private boolean inSimilarPackage(Type type, Type repositoryInterface) {
        String typePackage;
        String repoPackage = repositoryInterface.getPackageName();
        return repoPackage.startsWith(typePackage = type.getPackageName()) || typePackage.startsWith(repoPackage);
    }

    public void registerRepositoryProxy(NativeContext imageContext, Type repositoryType, Set<String> processed) {
        List repositoryInterfacesStrings = repositoryType.getInterfacesStrings();
        if (repositoryInterfacesStrings.size() != 0) {
            ArrayList<String> repositoryInterfaces = new ArrayList<String>();
            imageContext.log(LOG_PREFIX + repositoryType.getDottedName() + " is getting a proxy created");
            for (String s : repositoryInterfacesStrings) {
                repositoryInterfaces.add(s.replace("/", "."));
            }
            repositoryInterfaces.add("org.springframework.aop.SpringProxy");
            repositoryInterfaces.add("org.springframework.aop.framework.Advised");
            repositoryInterfaces.add("org.springframework.core.DecoratingProxy");
            imageContext.addProxy(repositoryInterfaces);
        } else {
            imageContext.log("SARCP: WARNING: unable to create proxy for repository " + repositoryType.getDottedName() + " because it has no interfaces");
        }
    }

    public void printSummary() {
    }
}

