/*
 * Decompiled with CFR 0.152.
 */
package org.springframework;

import java.util.ArrayList;
import java.util.List;
import org.springframework.nativex.type.ComponentProcessor;
import org.springframework.nativex.type.NativeContext;
import org.springframework.nativex.type.Type;

public class PrePostSecuredComponentProcessor
implements ComponentProcessor {
    public boolean handle(NativeContext imageContext, String componentType, List<String> classifiers) {
        Type type = imageContext.getTypeSystem().resolveName(componentType);
        return type != null && type.isAtPrePostSecured();
    }

    public void process(NativeContext imageContext, String componentType, List<String> classifiers) {
        Type type = imageContext.getTypeSystem().resolveName(componentType);
        ArrayList<String> prePostSecuredInterfaces = new ArrayList<String>();
        for (Type intface : type.getInterfaces()) {
            prePostSecuredInterfaces.add(intface.getDottedName());
        }
        if (prePostSecuredInterfaces.size() == 0) {
            imageContext.log("PrePostSecuredComponentProcessor: unable to find interfaces to proxy on " + componentType);
            return;
        }
        prePostSecuredInterfaces.add("org.springframework.aop.SpringProxy");
        prePostSecuredInterfaces.add("org.springframework.aop.framework.Advised");
        prePostSecuredInterfaces.add("org.springframework.core.DecoratingProxy");
        imageContext.addProxy(prePostSecuredInterfaces);
        imageContext.log("PrePostSecuredComponentProcessor: creating proxy for these interfaces: " + prePostSecuredInterfaces);
    }
}

