/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.utils.DirtyFlagMap;
import org.quartz.utils.StringKeyDirtyFlagMap;
import org.springframework.nativex.hint.FieldHint;
import org.springframework.nativex.hint.NativeHint;
import org.springframework.nativex.hint.NativeHints;
import org.springframework.nativex.hint.ResourceHint;
import org.springframework.nativex.hint.SerializationHint;
import org.springframework.nativex.hint.TypeAccess;
import org.springframework.nativex.hint.TypeHint;
import org.springframework.nativex.type.AccessDescriptor;
import org.springframework.nativex.type.HintDeclaration;
import org.springframework.nativex.type.NativeConfiguration;
import org.springframework.nativex.type.Type;
import org.springframework.nativex.type.TypeSystem;
import org.springframework.nativex.type.TypeSystemNativeConfiguration;
import org.springframework.scheduling.quartz.LocalDataSourceJobStore;
import org.springframework.scheduling.quartz.LocalTaskExecutorThreadPool;
import org.springframework.scheduling.quartz.ResourceLoaderClassLoadHelper;

@NativeHints(value={@NativeHint(trigger=Job.class, types={@TypeHint(types={CopyOnWriteArrayList.class}, fields={@FieldHint(allowWrite=true, allowUnsafeAccess=true, name="lock")}, access={TypeAccess.DECLARED_CONSTRUCTORS, TypeAccess.DECLARED_METHODS, TypeAccess.PUBLIC_METHODS})}, serializables={@SerializationHint(types={DirtyFlagMap.class, Long.class, Integer.class, Boolean.class, Double.class, Float.class, Date.class, String.class, StringKeyDirtyFlagMap.class, JobDataMap.class, HashMap.class})}, resources={@ResourceHint(patterns={"org/quartz/impl/jdbcjobstore/tables_.*.sql$"})}), @NativeHint(trigger=Job.class, types={@TypeHint(types={HashMap.class}, fields={@FieldHint(allowUnsafeAccess=true, name="threshold"), @FieldHint(allowUnsafeAccess=true, name="loadFactor")}, access={TypeAccess.DECLARED_CONSTRUCTORS, TypeAccess.DECLARED_METHODS, TypeAccess.PUBLIC_METHODS})}), @NativeHint(trigger=DirtyFlagMap.class, types={@TypeHint(types={HashMap.class}), @TypeHint(access={TypeAccess.DECLARED_CONSTRUCTORS, TypeAccess.DECLARED_METHODS, TypeAccess.PUBLIC_METHODS}, types={SimpleTriggerImpl.class, DirtyFlagMap.class, StdJDBCDelegate.class, RAMJobStore.class, LocalDataSourceJobStore.class, SimpleThreadPool.class, ResourceLoaderClassLoadHelper.class, LocalTaskExecutorThreadPool.class, StdSchedulerFactory.class})})})
public class QuartzHints
implements NativeConfiguration,
TypeSystemNativeConfiguration {
    public List<HintDeclaration> computeHints(TypeSystem typeSystem) {
        Type job = typeSystem.resolve("org/quartz/Job", true);
        if (job != null) {
            List jobSubtypes = job.getSubtypes();
            HintDeclaration hintDeclaration = new HintDeclaration();
            for (Type jobSubtype : jobSubtypes) {
                hintDeclaration.addDependantType(jobSubtype.getDottedName(), new AccessDescriptor(Integer.valueOf(126)));
            }
            return Collections.singletonList(hintDeclaration);
        }
        return Collections.emptyList();
    }
}

