/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.bind.Binder;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.DecoratingProxy;
import org.springframework.integration.annotation.Aggregator;
import org.springframework.integration.annotation.BridgeFrom;
import org.springframework.integration.annotation.BridgeTo;
import org.springframework.integration.annotation.Filter;
import org.springframework.integration.annotation.Gateway;
import org.springframework.integration.annotation.GatewayHeader;
import org.springframework.integration.annotation.InboundChannelAdapter;
import org.springframework.integration.annotation.Poller;
import org.springframework.integration.annotation.Publisher;
import org.springframework.integration.annotation.Router;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.annotation.Splitter;
import org.springframework.integration.annotation.Transformer;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.config.IntegrationManagementConfiguration;
import org.springframework.integration.config.IntegrationRegistrar;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.core.GenericSelector;
import org.springframework.integration.core.Pausable;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.file.splitter.FileSplitter;
import org.springframework.integration.gateway.MethodArgsHolder;
import org.springframework.integration.gateway.RequestReplyExchanger;
import org.springframework.integration.graph.Graph;
import org.springframework.integration.graph.LinkNode;
import org.springframework.integration.graph.ReceiveCounters;
import org.springframework.integration.graph.SendTimers;
import org.springframework.integration.graph.TimerStats;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.DelayHandler;
import org.springframework.integration.handler.GenericHandler;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.http.config.HttpContextUtils;
import org.springframework.integration.http.inbound.BaseHttpInboundEndpoint;
import org.springframework.integration.http.inbound.IntegrationRequestMappingHandlerMapping;
import org.springframework.integration.http.management.IntegrationGraphController;
import org.springframework.integration.jdbc.store.JdbcMessageStore;
import org.springframework.integration.json.JsonPathUtils;
import org.springframework.integration.message.AdviceMessage;
import org.springframework.integration.routingslip.ExpressionEvaluatingRoutingSlipRouteStrategy;
import org.springframework.integration.store.MessageGroupMetadata;
import org.springframework.integration.store.MessageHolder;
import org.springframework.integration.store.MessageMetadata;
import org.springframework.integration.support.MutableMessage;
import org.springframework.integration.support.MutableMessageHeaders;
import org.springframework.integration.support.json.Jackson2JsonObjectMapper;
import org.springframework.integration.support.json.JacksonPresent;
import org.springframework.integration.transformer.GenericTransformer;
import org.springframework.integration.util.ClassUtils;
import org.springframework.integration.webflux.inbound.WebFluxIntegrationRequestMappingHandlerMapping;
import org.springframework.integration.websocket.config.WebSocketIntegrationConfigurationInitializer;
import org.springframework.integration.xml.transformer.UnmarshallingTransformer;
import org.springframework.integration.xml.transformer.XsltPayloadTransformer;
import org.springframework.integration.xml.xpath.XPathUtils;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.nativex.hint.InitializationHint;
import org.springframework.nativex.hint.InitializationTime;
import org.springframework.nativex.hint.JdkProxyHint;
import org.springframework.nativex.hint.NativeHint;
import org.springframework.nativex.hint.NativeHints;
import org.springframework.nativex.hint.ResourceHint;
import org.springframework.nativex.hint.SerializationHint;
import org.springframework.nativex.hint.TypeAccess;
import org.springframework.nativex.hint.TypeHint;
import org.springframework.nativex.type.AccessDescriptor;
import org.springframework.nativex.type.HintDeclaration;
import org.springframework.nativex.type.NativeConfiguration;
import org.springframework.nativex.type.TypeProcessor;
import org.springframework.nativex.type.TypeSystem;
import org.springframework.nativex.type.TypeSystemNativeConfiguration;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.server.WebHandler;
import org.springframework.ws.mime.MimeMessage;

@NativeHints(value={@NativeHint(trigger=JdbcMessageStore.class, resources={@ResourceHint(patterns={"org/springframework/integration/jdbc/schema-.*.sql"})}), @NativeHint(trigger=IntegrationManagementConfiguration.class, initialization={@InitializationHint(initTime=InitializationTime.BUILD, types={IntegrationRegistrar.class, JacksonPresent.class, HttpContextUtils.class, WebSocketIntegrationConfigurationInitializer.class})}, resources={@ResourceHint(patterns={"META-INF/spring.integration.properties"})}, types={@TypeHint(access={TypeAccess.DECLARED_CONSTRUCTORS, TypeAccess.DECLARED_METHODS, TypeAccess.PUBLIC_METHODS}, types={IntegrationFlow.class, RequestReplyExchanger.class, Graph.class, LinkNode.class, SendTimers.class, TimerStats.class, ReceiveCounters.class, IntegrationGraphController.class, AbstractReplyProducingMessageHandler.RequestHandler.class}), @TypeHint(access={TypeAccess.PUBLIC_METHODS}, types={BeanExpressionContext.class, ConsumerEndpointFactoryBean.class, IntegrationContextUtils.class, XPathUtils.class, JsonPathUtils.class, JsonPath.class, MethodArgsHolder.class, ExpressionEvaluatingRoutingSlipRouteStrategy.RequestAndReply.class, Pausable.class, ServiceActivator.class, Splitter.class, Transformer.class, Router.class, Filter.class, BridgeFrom.class, BridgeTo.class, Aggregator.class, Gateway.class, GatewayHeader.class, InboundChannelAdapter.class, Poller.class, Publisher.class})}, serializables={@SerializationHint(types={Number.class, ArrayList.class, HashMap.class, Properties.class, Hashtable.class, Exception.class, UUID.class, GenericMessage.class, ErrorMessage.class, MessageHeaders.class, AdviceMessage.class, MutableMessage.class, MutableMessageHeaders.class, MessageGroupMetadata.class, MessageHolder.class, MessageMetadata.class, MessageHistory.class, MessageHistory.Entry.class, DelayHandler.DelayedMessageWrapper.class})}, jdkProxies={@JdkProxyHint(types={RequestReplyExchanger.class, SpringProxy.class, Advised.class, DecoratingProxy.class}), @JdkProxyHint(types={AbstractReplyProducingMessageHandler.RequestHandler.class, SpringProxy.class, Advised.class, DecoratingProxy.class}), @JdkProxyHint(types={IntegrationFlow.class, SmartLifecycle.class, SpringProxy.class, Advised.class, DecoratingProxy.class})}), @NativeHint(trigger=ClassUtils.class, types={@TypeHint(types={GenericSelector.class, GenericTransformer.class, GenericHandler.class, Function.class, Supplier.class, Function0.class, Function1.class, Unit.class}, access={TypeAccess.PUBLIC_METHODS})}), @NativeHint(trigger=FileSplitter.class, serializables={@SerializationHint(types={FileSplitter.FileMarker.class, FileSplitter.FileMarker.Mark.class})}), @NativeHint(trigger=XsltPayloadTransformer.class, types={@TypeHint(types={ServletContextResource.class}, access={})}), @NativeHint(trigger=UnmarshallingTransformer.class, types={@TypeHint(types={MimeMessage.class}, access={})}), @NativeHint(trigger=BaseHttpInboundEndpoint.class, types={@TypeHint(types={Binder.class}, typeNames={"com.rometools.rome.feed.atom.Feed"}, access={})}), @NativeHint(trigger=IntegrationRequestMappingHandlerMapping.class, types={@TypeHint(types={HttpRequestHandler.class}, access={TypeAccess.PUBLIC_METHODS})}), @NativeHint(trigger=WebFluxIntegrationRequestMappingHandlerMapping.class, types={@TypeHint(types={WebHandler.class}, access={TypeAccess.PUBLIC_METHODS})}), @NativeHint(trigger=ObjectMapper.class, initialization={@InitializationHint(initTime=InitializationTime.BUILD, types={Jackson2JsonObjectMapper.class})})})
public class IntegrationHints
implements NativeConfiguration,
TypeSystemNativeConfiguration {
    private static final String MESSAGING_GATEWAY_ANNOTATION = "Lorg/springframework/integration/annotation/MessagingGateway;";
    private static final String ABSTRACT_ENDPOINT_TYPE = "Lorg/springframework/integration/endpoint/AbstractEndpoint;";
    private static final String INTEGRATION_NODE_TYPE = "Lorg/springframework/integration/graph/IntegrationNode;";
    private static final String MESSAGE_TYPE = "org/springframework/messaging/Message";

    public List<HintDeclaration> computeHints(TypeSystem typeSystem) {
        ArrayList<HintDeclaration> hints = new ArrayList<HintDeclaration>();
        hints.addAll(IntegrationHints.computeMessagingGatewayHints(typeSystem));
        hints.addAll(IntegrationHints.computeAbstractEndpointHints(typeSystem));
        hints.addAll(IntegrationHints.computeIntegrationNodeHints(typeSystem));
        hints.addAll(IntegrationHints.computeMessageHints(typeSystem));
        return hints;
    }

    private static List<HintDeclaration> computeMessagingGatewayHints(TypeSystem typeSystem) {
        return TypeProcessor.namedProcessor((String)"IntegrationHints - MessagingGateway").skipMethodInspection().skipFieldInspection().skipConstructorInspection().filter(type -> type.hasAnnotationInHierarchy(MESSAGING_GATEWAY_ANNOTATION) && type.isInterface() && !type.isAnnotation()).limitInspectionDepth(0).onTypeDiscovered((type, context) -> context.addProxy(new String[]{type.getDottedName(), "org.springframework.aop.SpringProxy", "org.springframework.aop.framework.Advised", "org.springframework.core.DecoratingProxy"})).use(typeSystem).processTypes();
    }

    private static List<HintDeclaration> computeAbstractEndpointHints(TypeSystem typeSystem) {
        return TypeProcessor.namedProcessor((String)"IntegrationHints - AbstractEndpoint").skipAnnotationInspection().skipMethodInspection().skipFieldInspection().skipConstructorInspection().filter(type -> type.extendsClass(ABSTRACT_ENDPOINT_TYPE)).onTypeDiscovered((type, context) -> context.addReflectiveAccess(type, new AccessDescriptor(Integer.valueOf(34)))).use(typeSystem).processTypes();
    }

    private static List<HintDeclaration> computeIntegrationNodeHints(TypeSystem typeSystem) {
        return TypeProcessor.namedProcessor((String)"IntegrationHints - IntegrationNode").skipAnnotationInspection().skipMethodInspection().skipFieldInspection().skipConstructorInspection().filter(type -> type.extendsClass(INTEGRATION_NODE_TYPE)).onTypeDiscovered((type, context) -> context.addReflectiveAccess(type, new AccessDescriptor(Integer.valueOf(126)))).use(typeSystem).processTypes();
    }

    private static List<HintDeclaration> computeMessageHints(TypeSystem typeSystem) {
        return TypeProcessor.namedProcessor((String)"IntegrationHints - Message").skipAnnotationInspection().skipMethodInspection().skipFieldInspection().skipConstructorInspection().filter(type -> type.implementsInterface(MESSAGE_TYPE, true)).onTypeDiscovered((type, context) -> context.addReflectiveAccess(type, new AccessDescriptor(Integer.valueOf(34)))).use(typeSystem).processTypes();
    }
}

