/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.autoconfigure.jackson.JacksonHints;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.server.ExposesResourceFor;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.core.DefaultLinkRelationProvider;
import org.springframework.hateoas.server.core.EvoInflectorLinkRelationProvider;
import org.springframework.hateoas.server.core.LastInvocationAware;
import org.springframework.hateoas.server.core.Relation;
import org.springframework.hateoas.server.mvc.UriComponentsContributor;
import org.springframework.nativex.domain.proxies.AotProxyDescriptor;
import org.springframework.nativex.domain.proxies.JdkProxyDescriptor;
import org.springframework.nativex.hint.FieldHint;
import org.springframework.nativex.hint.InitializationHint;
import org.springframework.nativex.hint.InitializationTime;
import org.springframework.nativex.hint.JdkProxyHint;
import org.springframework.nativex.hint.NativeHint;
import org.springframework.nativex.hint.TypeAccess;
import org.springframework.nativex.hint.TypeHint;
import org.springframework.nativex.type.AccessDescriptor;
import org.springframework.nativex.type.HintDeclaration;
import org.springframework.nativex.type.Method;
import org.springframework.nativex.type.MissingTypeException;
import org.springframework.nativex.type.NativeConfiguration;
import org.springframework.nativex.type.Type;
import org.springframework.nativex.type.TypeProcessor;
import org.springframework.nativex.type.TypeSystem;
import org.springframework.nativex.type.TypeSystemNativeConfiguration;
import org.springframework.plugin.PluginHints;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

@NativeHint(trigger=HalConfiguration.class, types={@TypeHint(types={EnableHypermediaSupport.HypermediaType.class, ExposesResourceFor.class, RepresentationModelAssembler.class, DefaultLinkRelationProvider.class, EvoInflectorLinkRelationProvider.class, LastInvocationAware.class, Relation.class, UriComponentsContributor.class, Affordance.class, AffordanceModel.class}, access={TypeAccess.DECLARED_CONSTRUCTORS, TypeAccess.DECLARED_METHODS, TypeAccess.PUBLIC_METHODS}), @TypeHint(typeNames={"org.atteo.evo.inflector.English"}, access={TypeAccess.DECLARED_CONSTRUCTORS, TypeAccess.DECLARED_METHODS, TypeAccess.PUBLIC_METHODS}), @TypeHint(types={CollectionModel.class}, fields={@FieldHint(name="content", allowUnsafeAccess=true, allowWrite=true)})}, initialization={@InitializationHint(types={MediaTypes.class, MimeTypeUtils.class}, initTime=InitializationTime.BUILD)}, jdkProxies={@JdkProxyHint(typeNames={"java.util.List", "org.springframework.aop.SpringProxy", "org.springframework.aop.framework.Advised", "org.springframework.core.DecoratingProxy"}), @JdkProxyHint(typeNames={"org.springframework.web.bind.annotation.RequestParam", "org.springframework.core.annotation.SynthesizedAnnotation"}), @JdkProxyHint(typeNames={"org.springframework.web.bind.annotation.RequestBody", "org.springframework.core.annotation.SynthesizedAnnotation"}), @JdkProxyHint(typeNames={"org.springframework.web.bind.annotation.PathVariable", "org.springframework.core.annotation.SynthesizedAnnotation"}), @JdkProxyHint(typeNames={"org.springframework.web.bind.annotation.ModelAttribute", "org.springframework.core.annotation.SynthesizedAnnotation"}), @JdkProxyHint(typeNames={"org.springframework.stereotype.Controller", "org.springframework.core.annotation.SynthesizedAnnotation"}), @JdkProxyHint(typeNames={"org.springframework.web.bind.annotation.ControllerAdvice", "org.springframework.core.annotation.SynthesizedAnnotation"}), @JdkProxyHint(typeNames={"org.springframework.web.bind.annotation.RequestHeader", "org.springframework.core.annotation.SynthesizedAnnotation"}), @JdkProxyHint(typeNames={"org.springframework.hateoas.server.core.Relation", "org.springframework.core.annotation.SynthesizedAnnotation"})}, imports={PluginHints.class, JacksonHints.class})
public class HateoasHints
implements NativeConfiguration,
TypeSystemNativeConfiguration {
    private static final String ENTITY_LINKS = "org/springframework/hateoas/server/EntityLinks";
    private static final String JACKSON_ANNOTATION = "Lcom/fasterxml/jackson/annotation/JacksonAnnotation;";
    private static final String ENABLE_HYPERMEDIA_SUPPORT = "Lorg/springframework/hateoas/config/EnableHypermediaSupport;";

    public List<HintDeclaration> computeHints(TypeSystem typeSystem) {
        if (!ClassUtils.isPresent((String)"org.springframework.hateoas.config.EnableHypermediaSupport", null)) {
            return Collections.emptyList();
        }
        Set<String> hypermediaFormats = this.computeConfiguredHypermediaFormats(typeSystem);
        ArrayList<HintDeclaration> hints = new ArrayList<HintDeclaration>();
        hints.addAll(this.computePlugins(typeSystem));
        hints.addAll(this.computeAtConfigurationClasses(typeSystem, hypermediaFormats));
        hints.addAll(this.computeRepresentationModels(typeSystem));
        hints.addAll(this.computeEntityLinks(typeSystem));
        hints.addAll(this.computeJacksonMappings(typeSystem, hypermediaFormats));
        hints.addAll(this.computeControllerProxies(typeSystem));
        return hints;
    }

    private Set<String> computeConfiguredHypermediaFormats(TypeSystem typeSystem) {
        return typeSystem.scanUserCodeDirectoriesAndSpringJars(type -> {
            try {
                return type.isAnnotated(ENABLE_HYPERMEDIA_SUPPORT);
            }
            catch (MissingTypeException e) {
                return false;
            }
        }).flatMap(type -> {
            try {
                String formats = type.getAnnotationValuesInHierarchy(ENABLE_HYPERMEDIA_SUPPORT).getOrDefault("type", "");
                return StringUtils.hasText((String)formats) ? Stream.of(formats.split(";")) : Stream.empty();
            }
            catch (MissingTypeException ex) {
                return Stream.empty();
            }
        }).map(it -> {
            String value;
            switch (value = it.replaceAll(".*org\\.springframework\\.hateoas\\.config\\.EnableHypermediaSupport\\$HypermediaType\\.", "").toLowerCase()) {
                case "hal_forms": {
                    return "hal";
                }
                case "collection_json": {
                    return "collectionjson";
                }
            }
            return value;
        }).collect(Collectors.toSet());
    }

    private List<HintDeclaration> computeAtConfigurationClasses(TypeSystem typeSystem, Set<String> hypermediaFormats) {
        return TypeProcessor.namedProcessor((String)"HateoasHints - Configuration Classes").skipTypesMatching(type -> {
            if (type.isPartOfDomain("org.springframework.hateoas.mediatype")) {
                return !this.isSupportedHypermediaFormat((Type)type, hypermediaFormats);
            }
            return false;
        }).skipAnnotationInspection().skipMethodInspection().skipFieldInspection().onTypeDiscovered((type, context) -> context.addReflectiveAccess(type, new AccessDescriptor(Integer.valueOf(126)))).use(typeSystem).toProcessTypesMatching(type -> type.isPartOfDomain("org.springframework.hateoas") && type.isAtConfiguration());
    }

    private List<HintDeclaration> computeEntityLinks(TypeSystem typeSystem) {
        return TypeProcessor.namedProcessor((String)"HateoasHints - EntityLinks").filterAnnotations(annotation -> annotation.isPartOfDomain("org.springframework")).skipTypesMatching(type -> !type.isPartOfDomain("org.springframework.hateoas")).use(typeSystem).toProcessTypesMatching(type -> type.implementsInterface(ENTITY_LINKS, true));
    }

    List<HintDeclaration> computeRepresentationModels(TypeSystem typeSystem) {
        return TypeProcessor.namedProcessor((String)"HateoasHints - RepresentationModel").skipTypesMatching(type -> type.isPartOfDomain("org.springframework.") || type.isPartOfDomain("com.fasterxml.jackson.")).filterAnnotations(annotation -> annotation.isPartOfDomain("org.springframework") || annotation.isPartOfDomain("com.fasterxml.jackson.annotation")).onTypeDiscovered((type, ctx) -> {
            if (type.belongsToPackage("java", true)) {
                ctx.addReflectiveAccess(type, new TypeAccess[]{TypeAccess.RESOURCE});
            } else {
                ctx.addReflectiveAccess(type, new TypeAccess[]{TypeAccess.PUBLIC_METHODS, TypeAccess.PUBLIC_CONSTRUCTORS, TypeAccess.DECLARED_FIELDS});
            }
        }).use(typeSystem).toProcessTypesMatching(type -> {
            try {
                return type.extendsClass("Lorg/springframework/hateoas/RepresentationModel;") || type.implementsInterface("org/springframework/hateoas/server/RepresentationModelProcessor", true);
            }
            catch (MissingTypeException missingTypeException) {
                return false;
            }
        });
    }

    List<HintDeclaration> computeControllerProxies(TypeSystem typeSystem) {
        return typeSystem.scanUserCodeDirectoriesAndSpringJars(HateoasHints::isWebControllerProxyCandidate).flatMap(type -> Stream.concat(Stream.of(type), type.getMethods().stream().filter(Method::isAtMapping).map(Method::getReturnType))).distinct().filter(Objects::nonNull).filter(t -> !t.isFinal()).map(type -> {
            HintDeclaration hint = new HintDeclaration();
            hint.addProxyDescriptor(this.lastInvocationAwareProxyDescriptor((Type)type));
            return hint;
        }).collect(Collectors.toList());
    }

    List<HintDeclaration> computeJacksonMappings(TypeSystem typeSystem, Set<String> hypermediaFormats) {
        return TypeProcessor.namedProcessor((String)"HateoasHints - Jackson Mapping Candidates").skipTypesMatching(type -> {
            if (type.isPartOfDomain("com.fasterxml.jackson.") || type.isPartOfDomain("java.")) {
                return true;
            }
            if (type.isPartOfDomain("org.springframework.")) {
                if (!type.isPartOfDomain("org.springframework.hateoas.")) {
                    return true;
                }
                return !this.isSupportedHypermediaFormat((Type)type, hypermediaFormats);
            }
            return false;
        }).filterAnnotations(annotation -> annotation.isPartOfDomain("com.fasterxml.jackson.")).use(typeSystem).toProcessTypesMatching(this::usesJackson);
    }

    private List<HintDeclaration> computePlugins(TypeSystem typeSystem) {
        return typeSystem.scanUserCodeDirectoriesAndSpringJars(type -> type.implementsInterface("org/springframework/plugin/core/Plugin", true)).map(type -> {
            HintDeclaration hint = new HintDeclaration();
            hint.addDependantType(type.getDottedName(), new AccessDescriptor(Integer.valueOf(126)));
            return hint;
        }).collect(Collectors.toList());
    }

    private static boolean isWebControllerProxyCandidate(Type type) {
        return (type.isAtController() || type.isAnnotated("Lorg/springframework/data/rest/webmvc/BasePathAwareController;")) && !type.isAnnotation();
    }

    private boolean usesJackson(Type type) {
        try {
            if (type.implementsInterface("com/fasterxml/jackson/databind/Module", true)) {
                return true;
            }
            if (type.extendsClass("Lorg/springframework/http/converter/json/MappingJackson2HttpMessageConverter;")) {
                return true;
            }
            if (type.extendsClass("Lcom/fasterxml/jackson/databind/JsonSerializer;") || type.extendsClass("Lcom/fasterxml/jackson/databind/JsonDeserializer;")) {
                return true;
            }
            if (type.getAnnotations().stream().filter(ann -> ann.isAnnotated(JACKSON_ANNOTATION)).findAny().isPresent()) {
                return true;
            }
            if (!type.getMethodsWithAnnotation(JACKSON_ANNOTATION, true).isEmpty()) {
                return true;
            }
            return !type.getFieldsWithAnnotation(JACKSON_ANNOTATION, true).isEmpty();
        }
        catch (MissingTypeException missingTypeException) {
            return false;
        }
    }

    private boolean isSupportedHypermediaFormat(Type type, Set<String> hypermediaFormats) {
        if (hypermediaFormats.isEmpty()) {
            return true;
        }
        if (!type.isPartOfDomain("org.springframework.hateoas.mediatype")) {
            return true;
        }
        if (type.getPackageName().equals("org.springframework.hateoas.mediatype")) {
            return true;
        }
        for (String hypermediaFormat : hypermediaFormats) {
            if (!type.getPackageName().contains(hypermediaFormat)) continue;
            return true;
        }
        return false;
    }

    private JdkProxyDescriptor lastInvocationAwareProxyDescriptor(Type type) {
        if (!type.isInterface()) {
            return new AotProxyDescriptor(type.getDottedName(), Collections.singletonList("org.springframework.hateoas.server.core.LastInvocationAware"), 2);
        }
        ArrayList<String> proxyInterfaces = new ArrayList<String>();
        proxyInterfaces.add("org.springframework.hateoas.server.core.LastInvocationAware");
        proxyInterfaces.add(type.getDottedName());
        for (Type intface : type.getInterfaces()) {
            proxyInterfaces.add(intface.getDottedName());
        }
        proxyInterfaces.add("org.springframework.aop.SpringProxy");
        proxyInterfaces.add("org.springframework.aop.framework.Advised");
        proxyInterfaces.add("org.springframework.core.DecoratingProxy");
        return new JdkProxyDescriptor(proxyInterfaces);
    }
}

