/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.util.ArrayList;
import java.util.List;

public class MethodDescriptor {
    private final String name;
    private final List<String> parameterTypes;

    public MethodDescriptor(String name, List<String> parameterTypes) {
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    public static List<MethodDescriptor> of(String[][] methodDescriptors) {
        ArrayList<MethodDescriptor> mds = new ArrayList<MethodDescriptor>();
        for (int i = 0; i < methodDescriptors.length; ++i) {
            String[] methodDescriptor = methodDescriptors[i];
            mds.add(MethodDescriptor.of(methodDescriptor));
        }
        return mds;
    }

    public static MethodDescriptor of(String[] methodDescriptor) {
        ArrayList<String> params = new ArrayList<String>();
        for (int p = 1; p < methodDescriptor.length; ++p) {
            params.add(methodDescriptor[p]);
        }
        return new MethodDescriptor(methodDescriptor[0], params);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParameterTypes() {
        return this.parameterTypes;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.name);
        s.append("(");
        for (int p = 0; p < this.parameterTypes.size(); ++p) {
            if (p > 0) {
                s.append(",");
            }
            s.append(this.parameterTypes.get(p));
        }
        s.append(")");
        return s.toString();
    }
}

