/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.graalvm.domain.init.InitializationDescriptor;
import org.springframework.graalvm.type.AccessDescriptor;
import org.springframework.graalvm.type.FieldDescriptor;
import org.springframework.graalvm.type.MethodDescriptor;
import org.springframework.graalvm.type.ProxyDescriptor;
import org.springframework.graalvm.type.ResourcesDescriptor;

public class CompilationHint {
    private String targetType;
    private Map<String, AccessDescriptor> specificTypes = new LinkedHashMap<String, AccessDescriptor>();
    public boolean follow = false;
    public boolean skipIfTypesMissing = false;
    private List<ProxyDescriptor> proxyDescriptor = new ArrayList<ProxyDescriptor>();
    private List<ResourcesDescriptor> resourceDescriptors = new ArrayList<ResourcesDescriptor>();
    private List<InitializationDescriptor> initializationDescriptors = new ArrayList<InitializationDescriptor>();
    private boolean applyToFunctional = true;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompilationHint");
        if (this.targetType != null) {
            sb.append(" for ").append(this.targetType);
        }
        sb.append(":");
        sb.append(this.specificTypes);
        return sb.toString();
    }

    public void setTargetType(String targetTypename) {
        this.targetType = targetTypename;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public Map<String, AccessDescriptor> getDependantTypes() {
        return this.specificTypes;
    }

    public void addDependantType(String className, Integer accessBits, List<MethodDescriptor> mds, List<FieldDescriptor> fds) {
        this.specificTypes.put(className, new AccessDescriptor(accessBits, mds, fds));
    }

    public void addDependantType(Class<?> clazz, Integer accessBits, List<MethodDescriptor> mds, List<FieldDescriptor> fds) {
        this.specificTypes.put(clazz.getName(), new AccessDescriptor(accessBits, mds, fds));
    }

    public void setAbortIfTypesMissing(Boolean b) {
        this.skipIfTypesMissing = b;
    }

    public boolean isAbortIfTypesMissing() {
        return this.skipIfTypesMissing;
    }

    public void setFollow(Boolean b) {
        this.follow = b;
    }

    public void addProxyDescriptor(ProxyDescriptor pd) {
        this.proxyDescriptor.add(pd);
    }

    public List<ProxyDescriptor> getProxyDescriptors() {
        return this.proxyDescriptor;
    }

    public void addResourcesDescriptor(ResourcesDescriptor rd) {
        this.resourceDescriptors.add(rd);
    }

    public void addInitializationDescriptor(InitializationDescriptor id) {
        this.initializationDescriptors.add(id);
    }

    public List<ResourcesDescriptor> getResourcesDescriptors() {
        return this.resourceDescriptors;
    }

    public void setApplyToFunctional(boolean b) {
        this.applyToFunctional = b;
    }

    public boolean applyToFunctional() {
        return this.applyToFunctional;
    }

    public List<InitializationDescriptor> getInitializationDescriptors() {
        return this.initializationDescriptors;
    }
}

