/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.graalvm.domain.init.InitializationDescriptor;
import org.springframework.graalvm.type.FieldDescriptor;
import org.springframework.graalvm.type.MethodDescriptor;
import org.springframework.graalvm.type.ProxyDescriptor;
import org.springframework.graalvm.type.ResourcesDescriptor;

public class RequestedConfigurationManager {
    private Map<String, Integer> requestedTypeAccesses = new HashMap<String, Integer>();
    private Map<String, List<MethodDescriptor>> requestedMethodAccesses = new HashMap<String, List<MethodDescriptor>>();
    private Map<String, List<FieldDescriptor>> requestedFieldAccesses = new HashMap<String, List<FieldDescriptor>>();
    private List<ProxyDescriptor> requestedProxies = new ArrayList<ProxyDescriptor>();
    private List<ResourcesDescriptor> requestedResources = new ArrayList<ResourcesDescriptor>();
    private List<InitializationDescriptor> requestedInitializations = new ArrayList<InitializationDescriptor>();

    public void requestTypeAccess(String type, Integer accessRequired) {
        this.requestTypeAccess(type, accessRequired, null, null);
    }

    public void requestTypeAccess(String type, Integer accessRequired, List<MethodDescriptor> mds, List<FieldDescriptor> fds) {
        if (type.indexOf("/") != -1) {
            throw new IllegalStateException("Only pass dotted names to request(), name was: " + type);
        }
        Integer existsAlready = this.requestedTypeAccesses.get(type);
        if (existsAlready != null) {
            this.requestedTypeAccesses.put(type, existsAlready | accessRequired);
        } else {
            this.requestedTypeAccesses.put(type, accessRequired);
        }
        if (mds != null) {
            List<MethodDescriptor> existingMds = this.requestedMethodAccesses.get(type);
            if (existingMds == null) {
                this.requestedMethodAccesses.put(type, new ArrayList<MethodDescriptor>(mds));
            } else {
                existingMds.addAll(mds);
            }
        }
        if (fds != null) {
            List<FieldDescriptor> existingFds = this.requestedFieldAccesses.get(type);
            if (existingFds == null) {
                this.requestedFieldAccesses.put(type, new ArrayList<FieldDescriptor>(fds));
            } else {
                existingFds.addAll(fds);
            }
        }
    }

    public Integer getTypeAccessRequestedFor(String type) {
        return this.requestedTypeAccesses.get(type);
    }

    public List<MethodDescriptor> getMethodAccessRequestedFor(String type) {
        return this.requestedMethodAccesses.get(type);
    }

    public List<FieldDescriptor> getFieldAccessRequestedFor(String type) {
        return this.requestedFieldAccesses.get(type);
    }

    public void reduceTypeAccess(String type, int newAccess) {
        if (type.indexOf("/") != -1) {
            throw new IllegalStateException("Only pass dotted names to request(), name was: " + type);
        }
        Integer existsAlready = this.requestedTypeAccesses.get(type);
        if (existsAlready == null) {
            throw new IllegalStateException("Cannot reduce access for " + type + " - it hasn't been previously registered");
        }
        this.requestedTypeAccesses.put(type, newAccess);
    }

    public void requestProxyDescriptors(List<ProxyDescriptor> proxyDescriptors) {
        for (ProxyDescriptor pd : proxyDescriptors) {
            this.requestedProxies.add(pd);
        }
    }

    public void requestResourcesDescriptors(List<ResourcesDescriptor> resourcesDescriptors) {
        for (ResourcesDescriptor rd : resourcesDescriptors) {
            this.requestedResources.add(rd);
        }
    }

    public void requestInitializationDescriptors(List<InitializationDescriptor> initializationDescriptors) {
        for (InitializationDescriptor id : initializationDescriptors) {
            this.requestedInitializations.add(id);
        }
    }

    public void requestInitializationDescriptors(InitializationDescriptor initializationDescriptor) {
        this.requestedInitializations.add(initializationDescriptor);
    }

    public Set<Map.Entry<String, Integer>> getRequestedTypeAccesses() {
        return this.requestedTypeAccesses.entrySet();
    }

    public List<ProxyDescriptor> getRequestedProxies() {
        return this.requestedProxies;
    }

    public List<ResourcesDescriptor> getRequestedResources() {
        return this.requestedResources;
    }

    public List<InitializationDescriptor> getRequestedInitializations() {
        return this.requestedInitializations;
    }

    public void mergeIn(RequestedConfigurationManager incomingRCM) {
        for (Map.Entry<String, Integer> entry : incomingRCM.getRequestedTypeAccesses()) {
            this.requestTypeAccess(entry.getKey(), entry.getValue());
        }
        this.requestInitializationDescriptors(incomingRCM.getRequestedInitializations());
        this.requestProxyDescriptors(incomingRCM.getRequestedProxies());
        this.requestResourcesDescriptors(incomingRCM.getRequestedResources());
    }

    public void addMethodDescriptors(String type, String[][] methods) {
        this.requestedMethodAccesses.put(type, MethodDescriptor.of(methods));
    }

    public void removeTypeAccess(String typename) {
        this.requestedTypeAccesses.remove(typename);
        this.requestedMethodAccesses.remove(typename);
        this.requestedFieldAccesses.remove(typename);
    }
}

