/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import java.io.InputStream;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.springframework.graalvm.domain.proxies.ProxiesDescriptor;
import org.springframework.graalvm.domain.proxies.ProxiesDescriptorJsonMarshaller;
import org.springframework.graalvm.domain.proxies.ProxyDescriptor;
import org.springframework.graalvm.support.SpringFeature;

public class DynamicProxiesHandler {
    private ImageClassLoader imageClassLoader;

    public ProxiesDescriptor compute() {
        try {
            InputStream s = this.getClass().getResourceAsStream("/proxies.json");
            ProxiesDescriptor pd = ProxiesDescriptorJsonMarshaller.read(s);
            return pd;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean addProxy(org.springframework.graalvm.type.ProxyDescriptor pd) {
        String[] types = pd.getTypes();
        Class[] interfaces = new Class[types.length];
        boolean isOK = true;
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            Class clazz = this.imageClassLoader.findClassByName(type, false);
            if (clazz == null) {
                isOK = false;
                break;
            }
            if (!clazz.isInterface()) {
                throw new RuntimeException("In ProxyDescriptor: " + pd + " the type \"" + type + "\" is not an interface.");
            }
            interfaces[i] = clazz;
        }
        if (isOK) {
            this.addProxy(interfaces);
            return true;
        }
        return false;
    }

    public boolean addProxy(List<String> interfaceNames) {
        boolean isOK = true;
        Class[] interfaces = new Class[interfaceNames.size()];
        for (int i = 0; i < interfaceNames.size(); ++i) {
            String className = interfaceNames.get(i);
            Class clazz = this.imageClassLoader.findClassByName(className, false);
            if (clazz == null) {
                isOK = false;
                break;
            }
            if (!clazz.isInterface()) {
                throw new RuntimeException("The type \"" + className + "\" is not an interface.");
            }
            interfaces[i] = clazz;
        }
        if (isOK) {
            this.addProxy(interfaces);
            return true;
        }
        return false;
    }

    public void addProxy(Class<?>[] interfaces) {
        DynamicProxyRegistry dynamicProxySupport = (DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class);
        dynamicProxySupport.addProxyClass((Class[])interfaces);
    }

    public void registerHybrid(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.imageClassLoader = access.getImageClassLoader();
    }

    public void register(Feature.DuringSetupAccess a) {
        ProxiesDescriptor pd = this.compute();
        System.out.println("Attempting proxy registration of #" + pd.getProxyDescriptors().size() + " proxies");
        int skippedProxiesCount = 0;
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.imageClassLoader = access.getImageClassLoader();
        DynamicProxyRegistry dynamicProxySupport = (DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class);
        for (ProxyDescriptor proxyDescriptor : pd.getProxyDescriptors()) {
            List<String> interfaceNames = proxyDescriptor.getInterfaces();
            boolean isOK = true;
            Class[] interfaces = new Class[interfaceNames.size()];
            for (int i = 0; i < interfaceNames.size(); ++i) {
                String className = interfaceNames.get(i);
                Class clazz = this.imageClassLoader.findClassByName(className, false);
                if (clazz == null) {
                    SpringFeature.log("Skipping proxy registration for " + interfaceNames + " because of missing type: " + className);
                    ++skippedProxiesCount;
                    isOK = false;
                    break;
                }
                if (!clazz.isInterface()) {
                    throw new RuntimeException("The class \"" + className + "\" is not an interface.");
                }
                interfaces[i] = clazz;
            }
            if (!isOK) continue;
            dynamicProxySupport.addProxyClass(interfaces);
        }
        if (skippedProxiesCount != 0) {
            System.out.println("Skipped registration of #" + skippedProxiesCount + " proxies - relevant types not on classpath");
        }
    }
}

