/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.substitutions;

import java.util.function.Predicate;
import org.springframework.graalvm.support.Mode;

public class FunctionalMode
implements Predicate<String> {
    private static Boolean isFunctionalMode = null;

    @Override
    public boolean test(String type) {
        if (isFunctionalMode == null) {
            String modeSet = System.getProperty("spring.native.mode");
            isFunctionalMode = modeSet != null ? Boolean.valueOf(modeSet.equalsIgnoreCase(Mode.FUNCTIONAL.name())) : (this.exists("org.springframework.init.func.InfrastructureInitializer") || this.exists("org.springframework.fu.kofu.KofuApplication") || this.exists("org.springframework.fu.jafu.JafuApplication") ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        return isFunctionalMode;
    }

    private boolean exists(String typename) {
        try {
            return Class.forName(typename, false, this.getClass().getClassLoader()) != null;
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            return false;
        }
    }
}

