/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.domain.reflect;

import java.util.ArrayList;
import java.util.List;
import org.springframework.graalvm.domain.reflect.ClassDescriptor;
import org.springframework.graalvm.domain.reflect.JsonMarshaller;

public class ReflectionDescriptor {
    private final List<ClassDescriptor> classDescriptors;

    public ReflectionDescriptor() {
        this.classDescriptors = new ArrayList<ClassDescriptor>();
    }

    public ReflectionDescriptor(ReflectionDescriptor metadata) {
        this.classDescriptors = new ArrayList<ClassDescriptor>(metadata.classDescriptors);
    }

    public void sort() {
        this.classDescriptors.sort((a, b) -> a.getName().compareTo(b.getName()));
    }

    public List<ClassDescriptor> getClassDescriptors() {
        return this.classDescriptors;
    }

    public void add(ClassDescriptor classDescriptor) {
        this.classDescriptors.add(classDescriptor);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("ClassDescriptors #%s\n", this.classDescriptors.size()));
        this.classDescriptors.forEach(cd -> result.append(String.format("%s: \n", cd)));
        return result.toString();
    }

    public boolean isEmpty() {
        return this.classDescriptors.isEmpty();
    }

    public static ReflectionDescriptor of(String jsonString) {
        try {
            return JsonMarshaller.read(jsonString);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read json:\n" + jsonString, e);
        }
    }

    public boolean hasClassDescriptor(String string) {
        for (ClassDescriptor cd : this.classDescriptors) {
            if (!cd.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public ClassDescriptor getClassDescriptor(String type) {
        for (ClassDescriptor cd : this.classDescriptors) {
            if (!cd.getName().equals(type)) continue;
            return cd;
        }
        return null;
    }
}

