/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.domain.reflect;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.graalvm.domain.reflect.MemberDescriptor;

public final class MethodDescriptor
extends MemberDescriptor
implements Comparable<MethodDescriptor> {
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final List<String> NO_PARAMS = Collections.emptyList();
    private List<String> parameterTypes;

    MethodDescriptor() {
    }

    MethodDescriptor(String name, List<String> parameterTypes) {
        super(name);
        this.parameterTypes = parameterTypes;
    }

    public List<String> getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(List<String> parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDescriptor other = (MethodDescriptor)o;
        boolean result = true;
        result = result && this.nullSafeEquals(this.name, other.name);
        result = result && this.nullSafeEquals(this.parameterTypes, other.parameterTypes);
        return result;
    }

    public int hashCode() {
        int result = this.nullSafeHashCode(this.name);
        result = 31 * result + this.nullSafeHashCode(this.parameterTypes);
        return result;
    }

    public String toString() {
        StringBuilder string = new StringBuilder(this.name);
        this.buildToStringProperty(string, "name", this.name);
        this.buildToStringProperty(string, "parameterTypes", this.parameterTypes);
        return string.toString();
    }

    @Override
    public int compareTo(MethodDescriptor o) {
        return this.getName().compareTo(o.getName());
    }

    public static MethodDescriptor of(String name, String ... parameterTypes) {
        MethodDescriptor md = new MethodDescriptor();
        md.setName(name);
        if (parameterTypes != null) {
            md.setParameterTypes(Arrays.asList(parameterTypes));
        } else {
            md.setParameterTypes(NO_PARAMS);
        }
        return md;
    }

    public static String[][] toStringArray(List<org.springframework.graalvm.type.MethodDescriptor> methods) {
        if (methods == null) {
            return null;
        }
        String[][] array = new String[methods.size()][];
        for (int m = 0; m < methods.size(); ++m) {
            org.springframework.graalvm.type.MethodDescriptor md = methods.get(m);
            array[m] = new String[md.getParameterTypes().size() + 1];
            int p = 0;
            array[m][p++] = md.getName();
            for (String pt : md.getParameterTypes()) {
                array[m][p++] = pt;
            }
        }
        return array;
    }
}

