/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.domain.reflect;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.springframework.graalvm.domain.reflect.ClassDescriptor;
import org.springframework.graalvm.domain.reflect.FieldDescriptor;
import org.springframework.graalvm.domain.reflect.Flag;
import org.springframework.graalvm.domain.reflect.JsonConverter;
import org.springframework.graalvm.domain.reflect.MethodDescriptor;
import org.springframework.graalvm.domain.reflect.ReflectionDescriptor;
import org.springframework.graalvm.json.JSONArray;
import org.springframework.graalvm.json.JSONObject;

public class JsonMarshaller {
    private static final int BUFFER_SIZE = 4098;

    public static void write(ReflectionDescriptor metadata, OutputStream outputStream) throws IOException {
        try {
            JsonConverter converter = new JsonConverter();
            JSONArray jsonArray = converter.toJsonArray(metadata);
            outputStream.write(jsonArray.toString(2).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new IllegalStateException(ex);
        }
    }

    public static ReflectionDescriptor read(String input) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));){
            ReflectionDescriptor reflectionDescriptor = JsonMarshaller.read(bais);
            return reflectionDescriptor;
        }
    }

    public static ReflectionDescriptor read(byte[] input) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(input);){
            ReflectionDescriptor reflectionDescriptor = JsonMarshaller.read(bais);
            return reflectionDescriptor;
        }
    }

    public static ReflectionDescriptor read(InputStream inputStream) {
        try {
            ReflectionDescriptor metadata = JsonMarshaller.toReflectionDescriptor(new JSONArray(JsonMarshaller.toString(inputStream)));
            return metadata;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read ReflectionDescriptor from inputstream", e);
        }
    }

    private static ReflectionDescriptor toReflectionDescriptor(JSONArray array) throws Exception {
        ReflectionDescriptor rd = new ReflectionDescriptor();
        for (int i = 0; i < array.length(); ++i) {
            ClassDescriptor cd = JsonMarshaller.toClassDescriptor((JSONObject)array.get(i));
            if (rd.hasClassDescriptor(cd.getName())) {
                System.out.println("DUPLICATE: " + cd.getName());
                rd.getClassDescriptor(cd.getName()).merge(cd);
                continue;
            }
            rd.add(cd);
        }
        return rd;
    }

    private static ClassDescriptor toClassDescriptor(JSONObject object) throws Exception {
        JSONArray methods;
        ClassDescriptor cd = new ClassDescriptor();
        cd.setName(object.getString("name"));
        for (Flag f : Flag.values()) {
            if (!object.optBoolean(f.name())) continue;
            cd.setFlag(f);
        }
        JSONArray fields = object.optJSONArray("fields");
        if (fields != null) {
            for (int i = 0; i < fields.length(); ++i) {
                cd.addFieldDescriptor(JsonMarshaller.toFieldDescriptor(fields.getJSONObject(i)));
            }
        }
        if ((methods = object.optJSONArray("methods")) != null) {
            for (int i = 0; i < methods.length(); ++i) {
                cd.addMethodDescriptor(JsonMarshaller.toMethodDescriptor(methods.getJSONObject(i)));
            }
        }
        return cd;
    }

    private static FieldDescriptor toFieldDescriptor(JSONObject object) throws Exception {
        String name = object.getString("name");
        boolean allowWrite = object.optBoolean("allowWrite");
        boolean allowUnsafeAccess = object.optBoolean("allowUnsafeAccess");
        return new FieldDescriptor(name, allowWrite, allowUnsafeAccess);
    }

    private static MethodDescriptor toMethodDescriptor(JSONObject object) throws Exception {
        String name = object.getString("name");
        JSONArray parameterTypes = object.optJSONArray("parameterTypes");
        ArrayList<String> listOfParameterTypes = null;
        if (parameterTypes != null) {
            listOfParameterTypes = new ArrayList<String>();
            for (int i = 0; i < parameterTypes.length(); ++i) {
                listOfParameterTypes.add(parameterTypes.getString(i));
            }
        }
        return new MethodDescriptor(name, listOfParameterTypes);
    }

    private static String toString(InputStream inputStream) throws IOException {
        int bytesRead;
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        char[] buffer = new char[4098];
        while ((bytesRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, bytesRead);
        }
        return out.toString();
    }
}

