/*
 * Decompiled with CFR 0.152.
 */
package org.springframework;

import java.util.ArrayList;
import java.util.List;
import org.springframework.graalvm.extension.ComponentProcessor;
import org.springframework.graalvm.extension.NativeImageContext;
import org.springframework.graalvm.type.Type;

public class TransactionalComponentProcessor
implements ComponentProcessor {
    @Override
    public boolean handle(NativeImageContext imageContext, String componentType, List<String> classifiers) {
        Type type = imageContext.getTypeSystem().resolveName(componentType);
        boolean isInteresting = type != null && (type.isTransactional() || type.hasTransactionalMethods());
        return isInteresting;
    }

    @Override
    public void process(NativeImageContext imageContext, String componentType, List<String> classifiers) {
        Type type = imageContext.getTypeSystem().resolveName(componentType);
        ArrayList<String> transactionalInterfaces = new ArrayList<String>();
        for (Type intface : type.getInterfaces()) {
            transactionalInterfaces.add(intface.getDottedName());
        }
        if (transactionalInterfaces.size() == 0) {
            imageContext.log("TransactionalComponentProcessor: unable to find interfaces to proxy on " + componentType);
            return;
        }
        transactionalInterfaces.add("org.springframework.aop.SpringProxy");
        transactionalInterfaces.add("org.springframework.aop.framework.Advised");
        transactionalInterfaces.add("org.springframework.core.DecoratingProxy");
        imageContext.addProxy(transactionalInterfaces);
        imageContext.log("TransactionalComponentProcessor: creating proxy for these interfaces: " + transactionalInterfaces);
    }
}

