/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.gaffer.GafferUtil;
import ch.qos.logback.classic.util.EnvUtil;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.net.URL;
import org.springframework.graalvm.substitutions.LogbackIsAround;
import org.springframework.graalvm.substitutions.OnlyIfPresent;
import org.springframework.graalvm.substitutions.RemoveXmlSupport;

@TargetClass(className="ch.qos.logback.classic.util.ContextInitializer", onlyWith={OnlyIfPresent.class, LogbackIsAround.class, RemoveXmlSupport.class})
final class Target_ContextInitializer {
    @Alias
    LoggerContext loggerContext;

    Target_ContextInitializer() {
    }

    @Substitute
    public void configureByResource(URL url) throws JoranException {
        if (url == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        String urlString = url.toString();
        if (urlString.endsWith("groovy")) {
            if (EnvUtil.isGroovyAvailable()) {
                GafferUtil.runGafferConfiguratorOn((LoggerContext)this.loggerContext, (Object)this, (URL)url);
            } else {
                StatusManager sm = this.loggerContext.getStatusManager();
                sm.add((Status)new ErrorStatus("Groovy classes are not available on the class path. ABORTING INITIALIZATION.", (Object)this.loggerContext));
            }
        } else {
            throw new LogbackException("Unexpected filename extension of file [" + url.toString() + "]. Should be either .groovy or .xml");
        }
    }
}

