/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.graalvm.substitutions.FormHttpMessageConverterIsAround;
import org.springframework.graalvm.substitutions.OnlyPresent;
import org.springframework.graalvm.substitutions.RemoveXmlSupport;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.cbor.MappingJackson2CborHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.JsonbHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;

@TargetClass(className="org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport", onlyWith={OnlyPresent.class, FormHttpMessageConverterIsAround.class, RemoveXmlSupport.class})
final class Target_WebMvcConfigurationSupport {
    @Alias
    private static boolean romePresent;
    @Alias
    private static boolean jaxb2Present;
    @Alias
    private static boolean jackson2Present;
    @Alias
    private static boolean jackson2XmlPresent;
    @Alias
    private static boolean jackson2SmilePresent;
    @Alias
    private static boolean jackson2CborPresent;
    @Alias
    private static boolean gsonPresent;
    @Alias
    private static boolean jsonbPresent;
    @Alias
    private ApplicationContext applicationContext;

    Target_WebMvcConfigurationSupport() {
    }

    @Substitute
    protected final void addDefaultHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Jackson2ObjectMapperBuilder builder;
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new ResourceRegionHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new FormHttpMessageConverter());
        if (romePresent) {
            messageConverters.add((HttpMessageConverter<?>)new AtomFeedHttpMessageConverter());
            messageConverters.add((HttpMessageConverter<?>)new RssChannelHttpMessageConverter());
        }
        if (jackson2XmlPresent) {
            builder = Jackson2ObjectMapperBuilder.xml();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2XmlHttpMessageConverter(builder.build()));
        }
        if (jackson2Present) {
            builder = Jackson2ObjectMapperBuilder.json();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(builder.build()));
        } else if (gsonPresent) {
            messageConverters.add((HttpMessageConverter<?>)new GsonHttpMessageConverter());
        } else if (jsonbPresent) {
            messageConverters.add((HttpMessageConverter<?>)new JsonbHttpMessageConverter());
        }
        if (jackson2SmilePresent) {
            builder = Jackson2ObjectMapperBuilder.smile();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2SmileHttpMessageConverter(builder.build()));
        }
        if (jackson2CborPresent) {
            builder = Jackson2ObjectMapperBuilder.cbor();
            if (this.applicationContext != null) {
                builder.applicationContext(this.applicationContext);
            }
            messageConverters.add((HttpMessageConverter<?>)new MappingJackson2CborHttpMessageConverter(builder.build()));
        }
    }
}

