/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.graalvm.substitutions.OnlyPresent;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.RequestToViewNameTranslator;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.function.support.HandlerFunctionAdapter;
import org.springframework.web.servlet.function.support.RouterFunctionMapping;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.mvc.HttpRequestHandlerAdapter;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import org.springframework.web.servlet.mvc.annotation.ResponseStatusExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.support.DefaultHandlerExceptionResolver;
import org.springframework.web.servlet.support.SessionFlashMapManager;
import org.springframework.web.servlet.theme.FixedThemeResolver;
import org.springframework.web.servlet.view.DefaultRequestToViewNameTranslator;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

@TargetClass(className="org.springframework.web.servlet.DispatcherServlet", onlyWith={OnlyPresent.class})
final class Target_DispatcherServlet {
    @Alias
    protected Log logger;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset, isFinal=true)
    private static Properties defaultStrategies;
    @Alias
    private MultipartResolver multipartResolver;
    @Alias
    private LocaleResolver localeResolver;
    @Alias
    private ThemeResolver themeResolver;
    @Alias
    private List<HandlerMapping> handlerMappings;
    @Alias
    private List<HandlerAdapter> handlerAdapters;
    @Alias
    private List<HandlerExceptionResolver> handlerExceptionResolvers;
    @Alias
    private RequestToViewNameTranslator viewNameTranslator;
    @Alias
    private FlashMapManager flashMapManager;
    @Alias
    private List<ViewResolver> viewResolvers;
    @Alias
    private boolean detectAllHandlerMappings;
    @Alias
    private boolean detectAllHandlerAdapters;
    @Alias
    private boolean detectAllHandlerExceptionResolvers;
    @Alias
    private boolean detectAllViewResolvers;
    @Alias
    private boolean throwExceptionIfNoHandlerFound;
    @Alias
    private boolean cleanupAfterInclude;

    Target_DispatcherServlet() {
    }

    @Substitute
    private void initMultipartResolver(ApplicationContext context) {
        block5: {
            try {
                this.multipartResolver = (MultipartResolver)context.getBean("multipartResolver", MultipartResolver.class);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Detected " + this.multipartResolver);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Detected " + this.multipartResolver.getClass().getSimpleName());
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.multipartResolver = null;
                if (!this.logger.isTraceEnabled()) break block5;
                this.logger.trace("No MultipartResolver multipartResolver declared");
            }
        }
    }

    @Substitute
    private void initLocaleResolver(ApplicationContext context) {
        block5: {
            try {
                this.localeResolver = (LocaleResolver)context.getBean("localeResolver", LocaleResolver.class);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Detected " + this.localeResolver);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Detected " + this.localeResolver.getClass().getSimpleName());
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                ((GenericApplicationContext)context).registerBean("localeResolver", LocaleResolver.class, AcceptHeaderLocaleResolver::new, new BeanDefinitionCustomizer[0]);
                this.localeResolver = (LocaleResolver)context.getBean("localeResolver", LocaleResolver.class);
                if (!this.logger.isTraceEnabled()) break block5;
                this.logger.trace("No LocaleResolver 'localeResolver': using default [" + this.localeResolver.getClass().getSimpleName() + "]");
            }
        }
    }

    @Substitute
    private void initThemeResolver(ApplicationContext context) {
        block5: {
            try {
                this.themeResolver = (ThemeResolver)context.getBean("themeResolver", ThemeResolver.class);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Detected " + this.themeResolver);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Detected " + this.themeResolver.getClass().getSimpleName());
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                ((GenericApplicationContext)context).registerBean("themeResolver", ThemeResolver.class, FixedThemeResolver::new, new BeanDefinitionCustomizer[0]);
                this.themeResolver = (ThemeResolver)context.getBean("themeResolver", ThemeResolver.class);
                if (!this.logger.isTraceEnabled()) break block5;
                this.logger.trace("No ThemeResolver 'themeResolver': using default [" + this.themeResolver.getClass().getSimpleName() + "]");
            }
        }
    }

    @Substitute
    private void initHandlerMappings(ApplicationContext context) {
        this.handlerMappings = null;
        if (this.detectAllHandlerMappings) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerMapping.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerMappings = new ArrayList(matchingBeans.values());
                AnnotationAwareOrderComparator.sort(this.handlerMappings);
            }
        } else {
            try {
                HandlerMapping hm = (HandlerMapping)context.getBean("handlerMapping", HandlerMapping.class);
                this.handlerMappings = Collections.singletonList(hm);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerMappings == null) {
            ((GenericApplicationContext)context).registerBean(HandlerMapping.class, BeanNameUrlHandlerMapping::new, new BeanDefinitionCustomizer[0]);
            ((GenericApplicationContext)context).registerBean(HandlerMapping.class, RequestMappingHandlerMapping::new, new BeanDefinitionCustomizer[0]);
            ((GenericApplicationContext)context).registerBean(HandlerMapping.class, RouterFunctionMapping::new, new BeanDefinitionCustomizer[0]);
            this.handlerMappings = (List)context.getBeansOfType(HandlerMapping.class).values();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("No HandlerMappings declared, using default strategies from DispatcherServlet.properties");
            }
        }
    }

    @Substitute
    private void initHandlerAdapters(ApplicationContext context) {
        this.handlerAdapters = null;
        if (this.detectAllHandlerAdapters) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerAdapter.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerAdapters = new ArrayList(matchingBeans.values());
                AnnotationAwareOrderComparator.sort(this.handlerAdapters);
            }
        } else {
            try {
                HandlerAdapter ha = (HandlerAdapter)context.getBean("handlerAdapter", HandlerAdapter.class);
                this.handlerAdapters = Collections.singletonList(ha);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerAdapters == null) {
            ((GenericApplicationContext)context).registerBean(HandlerAdapter.class, HttpRequestHandlerAdapter::new, new BeanDefinitionCustomizer[0]);
            ((GenericApplicationContext)context).registerBean(HandlerAdapter.class, SimpleControllerHandlerAdapter::new, new BeanDefinitionCustomizer[0]);
            ((GenericApplicationContext)context).registerBean(HandlerAdapter.class, RequestMappingHandlerAdapter::new, new BeanDefinitionCustomizer[0]);
            ((GenericApplicationContext)context).registerBean(HandlerAdapter.class, HandlerFunctionAdapter::new, new BeanDefinitionCustomizer[0]);
            this.handlerAdapters = (List)context.getBeansOfType(HandlerAdapter.class).values();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("No HandlerAdapters declared using default strategies from DispatcherServlet.properties");
            }
        }
    }

    @Substitute
    private void initHandlerExceptionResolvers(ApplicationContext context) {
        this.handlerExceptionResolvers = null;
        if (this.detectAllHandlerExceptionResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerExceptionResolver.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.handlerExceptionResolvers = new ArrayList(matchingBeans.values());
                AnnotationAwareOrderComparator.sort(this.handlerExceptionResolvers);
            }
        } else {
            try {
                HandlerExceptionResolver her = (HandlerExceptionResolver)context.getBean("handlerExceptionResolver", HandlerExceptionResolver.class);
                this.handlerExceptionResolvers = Collections.singletonList(her);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.handlerExceptionResolvers == null) {
            ((GenericApplicationContext)context).registerBean(HandlerExceptionResolver.class, ExceptionHandlerExceptionResolver::new, new BeanDefinitionCustomizer[0]);
            ((GenericApplicationContext)context).registerBean(HandlerExceptionResolver.class, ResponseStatusExceptionResolver::new, new BeanDefinitionCustomizer[0]);
            ((GenericApplicationContext)context).registerBean(HandlerExceptionResolver.class, DefaultHandlerExceptionResolver::new, new BeanDefinitionCustomizer[0]);
            this.handlerExceptionResolvers = (List)context.getBeansOfType(HandlerExceptionResolver.class).values();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("No HandlerExceptionResolvers declared using default strategies from DispatcherServlet.properties");
            }
        }
    }

    @Substitute
    private void initRequestToViewNameTranslator(ApplicationContext context) {
        block5: {
            try {
                this.viewNameTranslator = (RequestToViewNameTranslator)context.getBean("viewNameTranslator", RequestToViewNameTranslator.class);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Detected " + this.viewNameTranslator.getClass().getSimpleName());
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Detected " + this.viewNameTranslator);
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                ((GenericApplicationContext)context).registerBean("viewNameTranslator", RequestToViewNameTranslator.class, DefaultRequestToViewNameTranslator::new, new BeanDefinitionCustomizer[0]);
                this.viewNameTranslator = (RequestToViewNameTranslator)context.getBean("viewNameTranslator", RequestToViewNameTranslator.class);
                if (!this.logger.isTraceEnabled()) break block5;
                this.logger.trace("No RequestToViewNameTranslator 'viewNameTranslator': using default [" + this.viewNameTranslator.getClass().getSimpleName() + "]");
            }
        }
    }

    @Substitute
    private void initViewResolvers(ApplicationContext context) {
        this.viewResolvers = null;
        if (this.detectAllViewResolvers) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, ViewResolver.class, (boolean)true, (boolean)false);
            if (!matchingBeans.isEmpty()) {
                this.viewResolvers = new ArrayList(matchingBeans.values());
                AnnotationAwareOrderComparator.sort(this.viewResolvers);
            }
        } else {
            try {
                ViewResolver vr = (ViewResolver)context.getBean("viewResolver", ViewResolver.class);
                this.viewResolvers = Collections.singletonList(vr);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (this.viewResolvers == null) {
            ((GenericApplicationContext)context).registerBean("viewResolver", ViewResolver.class, InternalResourceViewResolver::new, new BeanDefinitionCustomizer[0]);
            this.viewResolvers = (List)context.getBeansOfType(ViewResolver.class).values();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("No ViewResolvers declared using default strategies from DispatcherServlet.properties");
            }
        }
    }

    @Substitute
    private void initFlashMapManager(ApplicationContext context) {
        block5: {
            try {
                this.flashMapManager = (FlashMapManager)context.getBean("flashMapManager", FlashMapManager.class);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Detected " + this.flashMapManager.getClass().getSimpleName());
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Detected " + this.flashMapManager);
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                ((GenericApplicationContext)context).registerBean("flashMapManager", FlashMapManager.class, SessionFlashMapManager::new, new BeanDefinitionCustomizer[0]);
                this.flashMapManager = (FlashMapManager)context.getBean("flashMapManager", FlashMapManager.class);
                if (!this.logger.isTraceEnabled()) break block5;
                this.logger.trace("No FlashMapManager 'flashMapManager': using default [" + this.flashMapManager.getClass().getSimpleName() + "]");
            }
        }
    }
}

