/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.List;
import org.springframework.graalvm.substitutions.FormHttpMessageConverterIsAround;
import org.springframework.graalvm.substitutions.OnlyPresent;
import org.springframework.graalvm.substitutions.RemoveXmlSupport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.cbor.MappingJackson2CborHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.JsonbHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.Target_RestTemplate_HeadersExtractor;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

@TargetClass(className="org.springframework.web.client.RestTemplate", onlyWith={OnlyPresent.class, FormHttpMessageConverterIsAround.class, RemoveXmlSupport.class})
final class Target_RestTemplate {
    @Alias
    private List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    @Alias
    private UriTemplateHandler uriTemplateHandler;
    @Alias
    private static boolean romePresent;
    @Alias
    private static boolean jaxb2Present;
    @Alias
    private static boolean jackson2Present;
    @Alias
    private static boolean jackson2XmlPresent;
    @Alias
    private static boolean jackson2SmilePresent;
    @Alias
    private static boolean jackson2CborPresent;
    @Alias
    private static boolean gsonPresent;
    @Alias
    private static boolean jsonbPresent;
    @Alias
    private ResponseErrorHandler errorHandler = new DefaultResponseErrorHandler();
    @Alias
    private ResponseExtractor<HttpHeaders> headersExtractor = new Target_RestTemplate_HeadersExtractor();

    @Substitute
    public Target_RestTemplate() {
        this.messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter(false));
        this.messageConverters.add((HttpMessageConverter<?>)new FormHttpMessageConverter());
        if (romePresent) {
            this.messageConverters.add((HttpMessageConverter<?>)new AtomFeedHttpMessageConverter());
            this.messageConverters.add((HttpMessageConverter<?>)new RssChannelHttpMessageConverter());
        }
        if (jackson2XmlPresent) {
            this.messageConverters.add((HttpMessageConverter<?>)new MappingJackson2XmlHttpMessageConverter());
        }
        if (jackson2Present) {
            this.messageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        } else if (gsonPresent) {
            this.messageConverters.add((HttpMessageConverter<?>)new GsonHttpMessageConverter());
        } else if (jsonbPresent) {
            this.messageConverters.add((HttpMessageConverter<?>)new JsonbHttpMessageConverter());
        }
        if (jackson2SmilePresent) {
            this.messageConverters.add((HttpMessageConverter<?>)new MappingJackson2SmileHttpMessageConverter());
        }
        if (jackson2CborPresent) {
            this.messageConverters.add((HttpMessageConverter<?>)new MappingJackson2CborHttpMessageConverter());
        }
        this.uriTemplateHandler = Target_RestTemplate.initUriTemplateHandler();
    }

    @Alias
    private static DefaultUriBuilderFactory initUriTemplateHandler() {
        return null;
    }
}

