/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.springframework.graalvm.domain.resources.ResourcesDescriptor;
import org.springframework.graalvm.domain.resources.ResourcesJsonMarshaller;
import org.springframework.graalvm.extension.ComponentProcessor;
import org.springframework.graalvm.type.CompilationHint;
import org.springframework.graalvm.type.MissingTypeException;
import org.springframework.graalvm.type.SpringConfiguration;
import org.springframework.graalvm.type.Type;
import sbg.asm.ClassReader;
import sbg.asm.tree.AnnotationNode;
import sbg.asm.tree.ClassNode;

public class TypeSystem {
    public static String SPRING_AT_CONFIGURATION = "Lorg/springframework/context/annotation/Configuration;";
    Map<String, AnnotationInfo> annotatedTypes;
    private SpringConfiguration hintLocator = null;
    private List<String> classpath;
    private Map<String, Type> typeCache = new HashMap<String, Type>();
    private Map<String, File> packageCache = new HashMap<String, File>();
    private Map<String, List<File>> appPackages = new HashMap<String, List<File>>();
    private Map<String, ResourcesDescriptor> resourceConfigurations;

    public static TypeSystem get(List<String> classpath) {
        return new TypeSystem(classpath);
    }

    public TypeSystem(List<String> classpath) {
        this.classpath = classpath;
        this.index();
    }

    public List<String> getClasspath() {
        return this.classpath;
    }

    public Type resolveName(String dottedTypeName) {
        return this.resolveDotted(dottedTypeName);
    }

    public Type resolveDotted(String dottedTypeName) {
        String slashedTypeName = this.toSlashedName(dottedTypeName);
        return this.resolveSlashed(slashedTypeName);
    }

    public Type resolveName(String desc, boolean silent) {
        return this.resolveDotted(desc, silent);
    }

    public Type resolveDotted(String desc, boolean silent) {
        try {
            return this.resolveDotted(desc);
        }
        catch (MissingTypeException mte) {
            if (silent) {
                return null;
            }
            throw mte;
        }
    }

    public boolean canResolveSlashed(String slashedTypeName) {
        try {
            return this.resolveSlashed(slashedTypeName) != null;
        }
        catch (RuntimeException re) {
            if (re.getMessage().startsWith("Unable to find class file for")) {
                return false;
            }
            throw re;
        }
    }

    public Type resolveSlashed(String slashedTypeName) {
        return this.resolveSlashed(slashedTypeName, false);
    }

    public Type resolveSlashed(String slashedTypeName, boolean allowNotFound) {
        byte[] bytes;
        Type type = this.typeCache.get(slashedTypeName);
        if (type == Type.MISSING) {
            if (allowNotFound) {
                return null;
            }
            throw new MissingTypeException(slashedTypeName);
        }
        if (type != null) {
            return type;
        }
        int dimensions = 0;
        String typeToLocate = slashedTypeName;
        if (slashedTypeName.endsWith("[]")) {
            String n = slashedTypeName;
            while (n.endsWith("[]")) {
                ++dimensions;
                n = n.substring(0, n.length() - 2);
            }
            typeToLocate = n;
        }
        if ((bytes = this.find(typeToLocate)) == null) {
            InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(typeToLocate + ".class");
            if (resourceAsStream == null) {
                this.typeCache.put(slashedTypeName, Type.MISSING);
                if (allowNotFound) {
                    return null;
                }
                throw new MissingTypeException(slashedTypeName);
            }
            try {
                bytes = TypeSystem.loadFromStream(resourceAsStream);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Problems loading class from resource stream: " + slashedTypeName, e);
            }
        }
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept(node, 2);
        type = Type.forClassNode(this, node, dimensions);
        this.typeCache.put(slashedTypeName, type);
        return type;
    }

    private String toSlashedName(String dottedTypeName) {
        return dottedTypeName.replace(".", "/");
    }

    public boolean canResolve(String classname) {
        if (classname.contains(".")) {
            throw new RuntimeException("Dont pass dotted names to resolve() :" + classname);
        }
        return this.canResolveSlashed(classname);
    }

    public Type resolve(String classname, boolean allowNotFound) {
        if (classname.contains(".")) {
            throw new RuntimeException("Dont pass dotted names to resolve() :" + classname);
        }
        return this.resolveSlashed(classname, allowNotFound);
    }

    public Type resolve(String classname) {
        return this.resolve(classname, false);
    }

    public Type Lresolve(String desc) {
        return this.resolve(desc.substring(1, desc.length() - 1));
    }

    public Type resolve(sbg.asm.Type type, boolean silent) {
        try {
            String desc = type.getDescriptor();
            return this.resolve(desc.substring(1, desc.length() - 1));
        }
        catch (MissingTypeException mte) {
            if (silent) {
                return null;
            }
            throw mte;
        }
    }

    public Type Lresolve(String desc, boolean silent) {
        try {
            return this.resolve(desc.substring(1, desc.length() - 1));
        }
        catch (MissingTypeException mte) {
            if (silent) {
                return null;
            }
            throw mte;
        }
    }

    public Set<String> findMissingTypesInHierarchyOfThisType(Type type) {
        return this.resolveComplete(type.getDescriptor());
    }

    public Set<String> resolveCompleteFindMissingAnnotationTypes(Type type) {
        LinkedHashSet<String> missingAnnotationTypes = new LinkedHashSet<String>();
        type.collectMissingAnnotationTypesHelper(missingAnnotationTypes, new HashSet<Type>());
        return missingAnnotationTypes;
    }

    public Set<String> resolveComplete(String desc) {
        LinkedHashSet<String> missingTypes = new LinkedHashSet<String>();
        this.resolveComplete(desc.substring(1, desc.length() - 1), missingTypes, new HashSet<String>());
        return missingTypes;
    }

    private void resolveComplete(String slashedDescriptor, Set<String> missingTypes, Set<String> visited) {
        if (visited.add(slashedDescriptor)) {
            Type baseType = this.resolve(slashedDescriptor, true);
            if (baseType == null) {
                missingTypes.add(slashedDescriptor);
            } else {
                List<String> interfaces;
                List<String> typesInSignature = baseType.getTypesInSignature();
                String superclassString = baseType.getSuperclassString();
                if (superclassString != null) {
                    this.resolveComplete(superclassString, missingTypes, visited);
                }
                if ((interfaces = baseType.getInterfacesStrings()) != null) {
                    for (String interfce : interfaces) {
                        this.resolveComplete(interfce, missingTypes, visited);
                    }
                }
            }
        }
    }

    public void index() {
        for (String s : this.classpath) {
            File f = new File(s);
            if (f.isDirectory()) {
                this.indexDir(f);
                continue;
            }
            this.indexJar(f);
        }
    }

    public void indexDir(File dir) {
        Path root = Paths.get(dir.toURI());
        try {
            Files.walk(root, new FileVisitOption[0]).filter(f -> f.toString().endsWith(".class")).map(f -> {
                String name = f.toString().substring(root.toString().length() + 1);
                int lastSlash = name.lastIndexOf("/");
                if (lastSlash != -1 && name.endsWith(".class")) {
                    return name.substring(0, lastSlash);
                }
                return null;
            }).forEach(n -> {
                if (n != null) {
                    List<File> dirs = this.appPackages.get(n);
                    if (dirs == null) {
                        dirs = new ArrayList<File>();
                        this.appPackages.put((String)n, dirs);
                    }
                    dirs.add(dir);
                }
            });
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to walk " + dir, ioe);
        }
    }

    public void indexJar(File jar) {
        try (ZipFile zf = new ZipFile(jar);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                int lastSlash;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class") || (lastSlash = name.lastIndexOf("/")) == -1 || !name.endsWith(".class")) continue;
                this.packageCache.put(name.substring(0, lastSlash), jar);
            }
        }
        catch (FileNotFoundException | NoSuchFileException fileIsntThere) {
            System.err.println("WARNING: Unable to find jar '" + jar + "' whilst scanning filesystem");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem during scan of " + jar, ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] find(String slashedTypeName) {
        String search = slashedTypeName + ".class";
        try {
            String packageName;
            int index = slashedTypeName.lastIndexOf("/");
            String string = packageName = index == -1 ? "" : slashedTypeName.substring(0, index);
            if (this.appPackages.containsKey(packageName)) {
                File f;
                File toTry;
                List<File> list = this.appPackages.get(packageName);
                Iterator<File> iterator = list.iterator();
                do {
                    if (!iterator.hasNext()) return null;
                } while (!(toTry = new File(f = iterator.next(), search)).exists());
                return TypeSystem.loadFromStream(new FileInputStream(toTry));
            }
            File jarfile = this.packageCache.get(packageName);
            if (jarfile == null) return null;
            try (ZipFile zf = new ZipFile(jarfile);){
                ZipEntry entry;
                String name;
                Enumeration<? extends ZipEntry> entries = zf.entries();
                do {
                    if (!entries.hasMoreElements()) return null;
                } while (!(name = (entry = entries.nextElement()).getName()).equals(search));
                byte[] byArray = TypeSystem.loadFromStream(zf.getInputStream(entry));
                return byArray;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem finding " + slashedTypeName, ioe);
        }
    }

    public static byte[] loadFromStream(InputStream stream) {
        try {
            BufferedInputStream bis = new BufferedInputStream(stream);
            int size = 2048;
            byte[] theData = new byte[size];
            int dataReadSoFar = 0;
            byte[] buffer = new byte[size / 2];
            int read = 0;
            while ((read = bis.read(buffer)) != -1) {
                if (read + dataReadSoFar > theData.length) {
                    byte[] newTheData = new byte[theData.length * 2];
                    System.arraycopy(theData, 0, newTheData, 0, dataReadSoFar);
                    theData = newTheData;
                }
                System.arraycopy(buffer, 0, theData, dataReadSoFar, read);
                dataReadSoFar += read;
            }
            bis.close();
            byte[] returnData = new byte[dataReadSoFar];
            System.arraycopy(theData, 0, returnData, 0, dataReadSoFar);
            byte[] byArray = returnData;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpectedly unable to load bytedata from input stream", e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        return "TypeSystem for cp(" + this.classpath + ")  jarPackages=#" + this.packageCache.size() + " appPackages=" + this.appPackages;
    }

    public void scan() {
        for (String classpathEntry : this.classpath) {
            File f = new File(classpathEntry);
            if (f.isDirectory()) {
                this.scanFiles(f, f);
                continue;
            }
            this.scanArchive(f);
        }
    }

    private void scanArchive(File f) {
        try (ZipFile zf = new ZipFile(f);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                ClassReader reader = new ClassReader(zf.getInputStream(entry));
                ClassNode node = new ClassNode();
                reader.accept(node, 7);
                AnnotationInfo ai = new AnnotationInfo(this, node);
                if (!ai.hasData()) continue;
                System.out.println("From " + entry.toString() + " got " + ai.toAnnotationString());
                this.annotatedTypes.put(node.name, ai);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanFiles(File file, File base) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.scanFiles(f, base);
            }
            return;
        } else {
            if (!file.getName().endsWith(".class")) return;
            try {
                byte[] bytes = Files.readAllBytes(Paths.get(file.toURI()));
                ClassReader reader = new ClassReader(bytes);
                ClassNode node = new ClassNode();
                reader.accept(node, 7);
                AnnotationInfo ai = new AnnotationInfo(this, node);
                if (!ai.hasData()) return;
                System.out.println("From " + file.getName() + " got " + ai.toAnnotationString());
                this.annotatedTypes.put(node.name, ai);
                return;
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }
    }

    private void ensureScanned() {
        if (this.annotatedTypes == null) {
            this.annotatedTypes = new HashMap<String, AnnotationInfo>();
            long t = System.currentTimeMillis();
            this.scan();
            System.out.println("SBG: scan time: " + (System.currentTimeMillis() - t) + "ms");
        }
    }

    public List<String> findTypesAnnotated(String annotationDescriptor, boolean metaAnnotated) {
        this.ensureScanned();
        if (metaAnnotated) {
            return this.annotatedTypes.values().stream().filter(ai -> ai.hasDescriptorMeta(annotationDescriptor)).map(ai -> ((AnnotationInfo)ai).name).collect(Collectors.toList());
        }
        return this.annotatedTypes.values().stream().filter(ai -> ai.hasDescriptor(annotationDescriptor)).map(ai -> ((AnnotationInfo)ai).name).collect(Collectors.toList());
    }

    public List<String> findTypesAnnotationAtConfiguration(boolean metaAnnotated) {
        return this.findTypesAnnotated(SPRING_AT_CONFIGURATION, metaAnnotated);
    }

    public List<CompilationHint> findHints(String typename) {
        if (typename.contains("/")) {
            typename = typename.endsWith(";") ? typename.substring(1, typename.length() - 1).replace("/", ".") : typename.replace("/", ".");
        }
        if (this.hintLocator == null) {
            this.hintLocator = new SpringConfiguration(this);
        }
        ArrayList<CompilationHint> results = new ArrayList<CompilationHint>();
        results.addAll(this.hintLocator.findProposedHints(typename));
        List<CompilationHint> declaredHints = this.resolveName(typename).getCompilationHints();
        results.addAll(declaredHints);
        return results;
    }

    public Map<String, ResourcesDescriptor> getResourceConfigurationsOnClasspath() {
        if (this.resourceConfigurations == null) {
            HashMap<String, ResourcesDescriptor> configs = new HashMap<String, ResourcesDescriptor>();
            for (String s : this.classpath) {
                File f = new File(s);
                if (f.isDirectory()) {
                    this.searchDir(f, filepath -> filepath.contains("META-INF/native-image") && filepath.endsWith("resource-config.json"), ResourcesJsonMarshaller::read, configs);
                    continue;
                }
                if (!f.isFile() || !f.toString().endsWith(".jar")) continue;
                this.searchJar(f, filepath -> filepath.contains("META-INF/native-image") && filepath.endsWith("resource-config.json"), ResourcesJsonMarshaller::read, configs);
            }
            this.resourceConfigurations = configs.isEmpty() ? Collections.emptyMap() : configs;
        }
        return this.resourceConfigurations;
    }

    private <T> void searchDir(File dir, Predicate<String> matchPredicate, Function<InputStream, T> converter, Map<String, T> collector) {
        Path root = Paths.get(dir.toURI());
        try {
            List found = Files.walk(root, new FileVisitOption[0]).filter(p -> matchPredicate.test(p.toAbsolutePath().toString())).map(p -> {
                try {
                    Object t = converter.apply(Files.newInputStream(p, new OpenOption[0]));
                    return new Tuple(p.toString(), t);
                }
                catch (Exception e) {
                    System.err.println("Unexpected problem reading " + p + ": " + e.getMessage());
                    return new Tuple<String, Object>(p.toString(), null);
                }
            }).collect(Collectors.toList());
            for (Tuple t : found) {
                collector.put((String)t.getKey(), t.getValue());
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to walk " + dir, ioe);
        }
    }

    private <T> void searchJar(File jar, Predicate<String> matchPredicate, Function<InputStream, T> converter, Map<String, T> collector) {
        try (ZipFile zf = new ZipFile(jar);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!matchPredicate.test(name)) continue;
                collector.put(jar.toURI().getPath().toString() + "!" + name, converter.apply(zf.getInputStream(entry)));
            }
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("WARNING: Unable to find jar '" + jar + "' whilst scanning filesystem");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem during scan of " + jar, ioe);
        }
    }

    public String findAnyResourceConfigIncludingSpringFactoriesPattern() {
        String existingConfigThatIncludesSpringFactories = null;
        Map<String, ResourcesDescriptor> resourceConfigurations = this.getResourceConfigurationsOnClasspath();
        block0: for (Map.Entry<String, ResourcesDescriptor> resourceConfiguration : resourceConfigurations.entrySet()) {
            List<String> patterns = resourceConfiguration.getValue().getPatterns();
            for (String pattern : patterns) {
                String slash = File.separator;
                if (!pattern.equals("META-INF" + slash + "spring.factories") && !pattern.equals("\\QMETA-INF" + slash + "spring.factories\\E")) continue;
                existingConfigThatIncludesSpringFactories = resourceConfiguration.getKey();
                break block0;
            }
        }
        return existingConfigThatIncludesSpringFactories;
    }

    public boolean shouldBeProcessed(String key) {
        String[] guardTypes = SpringConfiguration.findProposedFactoryGuards(key);
        if (guardTypes == null) {
            return true;
        }
        for (String guardType : guardTypes) {
            Type resolvedType = this.resolveDotted(guardType, true);
            if (resolvedType == null) continue;
            return true;
        }
        return false;
    }

    public List<ComponentProcessor> getComponentProcessors() {
        return SpringConfiguration.getComponentProcessors();
    }

    static class Tuple<K, V> {
        private final K key;
        private final V value;

        Tuple(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public String toString() {
            return this.key + ": hasData?" + (this.value != null);
        }
    }

    public static class AnnotationInfo {
        private String name;
        private TypeSystem typeSystem;
        private List<AnnotationNode> annotations;
        private List<AnnotationNode> metaAnnotationsList = null;

        public AnnotationInfo(TypeSystem typeSystem, ClassNode node) {
            this.typeSystem = typeSystem;
            this.name = node.name;
            this.annotations = node.visibleAnnotations;
        }

        public boolean hasData() {
            return this.annotations != null && this.annotations.size() != 0;
        }

        public String toAnnotationString() {
            StringBuilder sb = new StringBuilder();
            if (this.annotations != null) {
                for (AnnotationNode an : this.annotations) {
                    sb.append(an.desc);
                    sb.append("(");
                    List<Object> values = an.values;
                    if (values != null) {
                        for (int j = 0; j < values.size(); j += 2) {
                            sb.append(values.get(j));
                            sb.append("=");
                            sb.append(values.get(j + 1));
                        }
                    }
                    sb.append(")");
                }
            }
            return sb.toString();
        }

        public boolean hasDescriptor(String annotationDescriptor) {
            for (AnnotationNode an : this.annotations) {
                if (!an.desc.equals(annotationDescriptor)) continue;
                return true;
            }
            return false;
        }

        List<AnnotationNode> getMetaAnnotations() {
            if (this.metaAnnotationsList == null) {
                this.metaAnnotationsList = new ArrayList<AnnotationNode>();
                this.collectMetaAnnotations();
                if (this.metaAnnotationsList.size() == 0) {
                    this.metaAnnotationsList = Collections.emptyList();
                }
            }
            return this.metaAnnotationsList;
        }

        public boolean hasDescriptorMeta(String annotationDescriptor) {
            for (AnnotationNode an : this.annotations) {
                if (!an.desc.equals(annotationDescriptor)) continue;
                return true;
            }
            for (AnnotationNode an : this.getMetaAnnotations()) {
                if (!an.desc.equals(annotationDescriptor)) continue;
                return true;
            }
            return false;
        }

        private void collectMetaAnnotations() {
            for (AnnotationNode an : this.annotations) {
                AnnotationInfo ai = this.typeSystem.annotatedTypes.get(an.desc.substring(1, an.desc.length() - 1));
                if (ai == null || !ai.hasData()) continue;
                this.metaAnnotationsList.addAll(ai.getAnnotations());
                this.metaAnnotationsList.addAll(ai.getMetaAnnotations());
                if (!this.name.endsWith("DemoApplication")) continue;
                System.out.println("111");
                for (AnnotationNode ann : this.metaAnnotationsList) {
                    System.out.println(ann.desc);
                }
                System.out.println("222");
            }
        }

        private Collection<? extends AnnotationNode> getAnnotations() {
            return this.annotations;
        }
    }
}

