/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.springframework.graalvm.extension.ComponentProcessor;
import org.springframework.graalvm.extension.NativeImageConfiguration;
import org.springframework.graalvm.support.SpringFeature;
import org.springframework.graalvm.type.CompilationHint;
import org.springframework.graalvm.type.Type;
import org.springframework.graalvm.type.TypeSystem;

public class SpringConfiguration {
    private TypeSystem typeSystem;
    private static final Map<String, List<CompilationHint>> proposedHints = new HashMap<String, List<CompilationHint>>();
    private static final Map<String, String[]> proposedFactoryGuards = new HashMap<String, String[]>();
    private static final List<ComponentProcessor> processors = new ArrayList<ComponentProcessor>();

    public SpringConfiguration(TypeSystem typeSystem) {
        this.typeSystem = typeSystem;
        SpringFeature.log("SpringConfiguration: Discovering hints");
        ServiceLoader<NativeImageConfiguration> hintProviders = ServiceLoader.load(NativeImageConfiguration.class);
        for (NativeImageConfiguration hintProvider : hintProviders) {
            SpringFeature.log("SpringConfiguration: processing provider: " + hintProvider.getClass().getName());
            Type t = typeSystem.resolveName(hintProvider.getClass().getName());
            if (t == null) continue;
            List<CompilationHint> hints = t.getCompilationHints();
            try {
                hints.addAll(hintProvider.computeHints(typeSystem));
            }
            catch (NoClassDefFoundError ncdfe) {
                System.out.println("WARNING: Hint provider computeHints() method in " + hintProvider.getClass().getName() + " threw a NoClassDefFoundError for " + ncdfe.getMessage() + ": it is better if they handle that internally in case they are computing a variety of hints");
            }
            SpringFeature.log("Found " + hints.size() + " hints: " + hints);
            for (CompilationHint hint : hints) {
                List<CompilationHint> existingHints = proposedHints.get(hint.getTargetType());
                if (existingHints == null) {
                    existingHints = new ArrayList<CompilationHint>();
                    proposedHints.put(hint.getTargetType(), existingHints);
                }
                existingHints.add(hint);
            }
        }
        SpringFeature.log("Discovering component processors...");
        ServiceLoader<ComponentProcessor> componentProcessors = ServiceLoader.load(ComponentProcessor.class);
        for (ComponentProcessor componentProcessor : componentProcessors) {
            SpringFeature.log("SpringConfiguration: processing component processor: " + componentProcessor.getClass().getName());
            processors.add(componentProcessor);
        }
    }

    public List<CompilationHint> findProposedHints(String typename) {
        List<CompilationHint> results = proposedHints.get(typename);
        return results == null ? Collections.emptyList() : results;
    }

    public static List<ComponentProcessor> getComponentProcessors() {
        return processors;
    }

    public static String[] findProposedFactoryGuards(String key) {
        return proposedFactoryGuards.get(key);
    }

    static {
        proposedFactoryGuards.put("org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider", new String[]{"org.springframework.web.reactive.config.WebFluxConfigurer", "org.springframework.web.servlet.config.annotation.WebMvcConfigurer"});
    }
}

