/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class ConstantPoolScanner {
    private static final boolean DEBUG = false;
    private static final byte CONSTANT_Utf8 = 1;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_MethodHandle = 15;
    private static final byte CONSTANT_MethodType = 16;
    private static final byte CONSTANT_InvokeDynamic = 18;
    private byte[] classbytes;
    private int ptr;
    private Object[] cpdata;
    private int cpsize;
    private int[] type;
    private List<String> referencedClasses = new ArrayList<String>();
    private List<String> referencedMethods = new ArrayList<String>();
    private String slashedclassname;

    public static References getReferences(byte[] classbytes) {
        ConstantPoolScanner cpScanner = new ConstantPoolScanner(classbytes);
        return new References(cpScanner.slashedclassname, cpScanner.referencedClasses, cpScanner.referencedMethods);
    }

    public static References getReferences(File f) {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(f.toURI()));
            ConstantPoolScanner cpScanner = new ConstantPoolScanner(bytes);
            return new References(cpScanner.slashedclassname, cpScanner.referencedClasses, cpScanner.referencedMethods);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public ConstantPoolScanner(File f) {
        this(ConstantPoolScanner.readBytes(f));
    }

    public static byte[] readBytes(File f) {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(f.toURI()));
            return bytes;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private ConstantPoolScanner(byte[] bytes) {
        this.parseClass(bytes);
    }

    private void parseClass(byte[] bytes) {
        try {
            this.classbytes = bytes;
            this.ptr = 0;
            int magic = this.readInt();
            if (magic != -889275714) {
                throw new IllegalStateException("not bytecode, magic was 0x" + Integer.toString(magic, 16));
            }
            this.ptr += 4;
            this.cpsize = this.readUnsignedShort();
            this.cpdata = new Object[this.cpsize];
            this.type = new int[this.cpsize];
            for (int cpentry = 1; cpentry < this.cpsize; ++cpentry) {
                boolean wasDoubleSlotItem = this.processConstantPoolEntry(cpentry);
                if (!wasDoubleSlotItem) continue;
                ++cpentry;
            }
            this.ptr += 2;
            int thisclassname = this.readUnsignedShort();
            int classindex = (Integer)this.cpdata[thisclassname];
            this.slashedclassname = this.accessUtf8(classindex);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected problem processing bytes for class", e);
        }
    }

    public String getClassname() {
        return this.slashedclassname;
    }

    private String accessUtf8(int cpIndex) {
        String value;
        Object object = this.cpdata[cpIndex];
        if (object instanceof String) {
            return (String)object;
        }
        int[] ptrAndLen = (int[])object;
        try {
            value = new String(this.classbytes, ptrAndLen[0], ptrAndLen[1], "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Bad data found at constant pool position " + cpIndex + " offset=" + ptrAndLen[0] + " length=" + ptrAndLen[1], e);
        }
        this.cpdata[cpIndex] = value;
        return value;
    }

    private final int readInt() {
        return ((this.classbytes[this.ptr++] & 0xFF) << 24) + ((this.classbytes[this.ptr++] & 0xFF) << 16) + ((this.classbytes[this.ptr++] & 0xFF) << 8) + (this.classbytes[this.ptr++] & 0xFF);
    }

    private final int readUnsignedShort() {
        return ((this.classbytes[this.ptr++] & 0xFF) << 8) + (this.classbytes[this.ptr++] & 0xFF);
    }

    private boolean processConstantPoolEntry(int index) throws IOException {
        byte b = this.classbytes[this.ptr++];
        switch (b) {
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 18: {
                this.ptr += 4;
                break;
            }
            case 1: {
                int len = this.readUnsignedShort();
                this.cpdata[index] = new int[]{this.ptr, len};
                this.ptr += len;
                break;
            }
            case 5: 
            case 6: {
                this.ptr += 8;
                return true;
            }
            case 7: {
                this.type[index] = b;
                this.cpdata[index] = this.readUnsignedShort();
                break;
            }
            case 10: {
                this.type[index] = b;
                this.cpdata[index] = new int[]{this.readUnsignedShort(), this.readUnsignedShort()};
                break;
            }
            case 12: {
                this.cpdata[index] = this.readUnsignedShort();
                this.ptr += 2;
                break;
            }
            case 15: {
                this.ptr += 3;
                break;
            }
            case 8: 
            case 16: {
                this.ptr += 2;
                break;
            }
            default: {
                throw new IllegalStateException("Entry: " + index + " " + Byte.toString(b));
            }
        }
        return false;
    }

    private void computeReferences() {
        block4: for (int i = 0; i < this.cpsize; ++i) {
            switch (this.type[i]) {
                case 7: {
                    int classindex = (Integer)this.cpdata[i];
                    String classname = this.accessUtf8(classindex);
                    if (classname == null) {
                        throw new IllegalStateException();
                    }
                    this.referencedClasses.add(classname);
                    continue block4;
                }
                case 10: {
                    int[] indexes = (int[])this.cpdata[i];
                    int classindex2 = indexes[0];
                    int nameAndTypeIndex = indexes[1];
                    StringBuilder s = new StringBuilder();
                    String theClassName = this.accessUtf8((Integer)this.cpdata[classindex2]);
                    if (theClassName.charAt(0) != 'j') continue block4;
                    s.append(theClassName);
                    s.append(".");
                    s.append(this.accessUtf8((Integer)this.cpdata[nameAndTypeIndex]));
                    this.referencedMethods.add(s.toString());
                }
            }
        }
    }

    public static class References {
        public final String slashedClassName;
        private final List<String> referencedClasses;
        private final List<String> referencedMethods;

        References(String slashedClassName, List<String> rc, List<String> rm) {
            this.slashedClassName = slashedClassName;
            this.referencedClasses = rc;
            this.referencedMethods = rm;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("Class=").append(this.slashedClassName).append("\n");
            s.append("ReferencedClasses=#").append(this.referencedClasses.size()).append("\n");
            s.append("ReferencedMethods=#").append(this.referencedMethods.size()).append("\n");
            return s.toString();
        }

        public List<String> getReferencedClasses() {
            return this.referencedClasses;
        }
    }
}

