/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.type;

import java.util.ArrayList;
import org.springframework.graalvm.domain.reflect.Flag;

public class AccessBits {
    public static final int RESOURCE = 1;
    public static final int CLASS = 2;
    public static final int DECLARED_CONSTRUCTORS = 4;
    public static final int DECLARED_METHODS = 8;
    public static final int DECLARED_FIELDS = 16;
    public static final int NONE = 0;
    public static final int FULL_REFLECTION = 30;
    public static final int ALL = 31;
    public static final int CONFIGURATION = 31;
    public static final int EVERYTHING = 31;
    public static final int ANNOTATION = 11;
    public static final int LOAD_AND_CONSTRUCT = 6;
    private int value;

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object that) {
        if (that instanceof AccessBits) {
            return this.value == ((AccessBits)that).value;
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AccessBits(");
        if ((this.value & 1) != 0) {
            s.append("RES ");
        }
        if ((this.value & 2) != 0) {
            s.append("CLS ");
        }
        if ((this.value & 4) != 0) {
            s.append("CONS ");
        }
        if ((this.value & 8) != 0) {
            s.append("METHS ");
        }
        if ((this.value & 0x10) != 0) {
            s.append("FLDS ");
        }
        if (this.value == 0) {
            s.append("NONE");
        }
        return s.toString().trim() + ")";
    }

    public static Flag[] getFlags(int value) {
        ArrayList<Flag> flags = new ArrayList<Flag>();
        if ((value & 0x10) != 0) {
            flags.add(Flag.allDeclaredFields);
        }
        if ((value & 4) != 0) {
            flags.add(Flag.allDeclaredConstructors);
        }
        if ((value & 8) != 0) {
            flags.add(Flag.allDeclaredMethods);
        }
        return flags.toArray(new Flag[0]);
    }

    public AccessBits() {
        this.value = 0;
    }

    public AccessBits(int value) {
        this.value = value;
    }

    public static final AccessBits forValue(int value) {
        return new AccessBits(value);
    }

    public static final AccessBits forBits(int ... bits) {
        int value = 0;
        for (int i = 0; i < bits.length; ++i) {
            value |= bits[i];
        }
        return new AccessBits(value);
    }

    public boolean isResourceAccessRequired() {
        return (this.value & 1) != 0;
    }

    public boolean hasAccess(AccessBits accessBitsToCheck) {
        return (this.value ^ accessBitsToCheck.value) == 0;
    }

    public AccessBits with(AccessBits accessRequired) {
        return AccessBits.forValue(this.value | accessRequired.value);
    }

    public static String toString(Integer value) {
        StringBuilder s = new StringBuilder();
        s.append("AccessBits(");
        if ((value & 1) != 0) {
            s.append("RES ");
        }
        if ((value & 2) != 0) {
            s.append("CLS ");
        }
        if ((value & 4) != 0) {
            s.append("CONS ");
        }
        if ((value & 8) != 0) {
            s.append("METHS ");
        }
        if ((value & 0x10) != 0) {
            s.append("FLDS ");
        }
        if (value == 0) {
            s.append("NONE");
        }
        return s.toString().trim() + ")";
    }

    public static boolean isResourceAccessRequired(Integer typeKind) {
        return (typeKind & 1) != 0;
    }
}

