/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.hosted.ResourcesFeature;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.reflect.proxy.hosted.DynamicProxyFeature;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.nativeimage.hosted.Feature;
import org.springframework.graalvm.support.ConfigOptions;
import org.springframework.graalvm.support.DynamicProxiesHandler;
import org.springframework.graalvm.support.InitializationHandler;
import org.springframework.graalvm.support.ReflectionHandler;
import org.springframework.graalvm.support.ResourcesHandler;

@AutomaticFeature
public class SpringFeature
implements Feature {
    private ReflectionHandler reflectionHandler;
    private DynamicProxiesHandler dynamicProxiesHandler;
    private ResourcesHandler resourcesHandler;
    private InitializationHandler buildTimeInitializationHandler;

    public SpringFeature() {
        System.out.println(" ____             _               _____          _                  \n/ ___| _ __  _ __(_)_ __   __ _  |  ___|__  __ _| |_ _   _ _ __ ___ \n\\___ \\| '_ \\| '__| | '_ \\ / _` | | |_ / _ \\/ _` | __| | | | '__/ _ \\\n ___) | |_) | |  | | | | | (_| | |  _|  __/ (_| | |_| |_| | | |  __/\n|____/| .__/|_|  |_|_| |_|\\__, | |_|  \\___|\\__,_|\\__|\\__,_|_|  \\___|\n      |_|                 |___/                                     \n");
        if (!ConfigOptions.isVerbose()) {
            System.out.println("Use -Dspring.native.verbose=true on native-image call to see more detailed information from the feature");
        }
        this.reflectionHandler = new ReflectionHandler();
        this.dynamicProxiesHandler = new DynamicProxiesHandler();
        this.resourcesHandler = new ResourcesHandler(this.reflectionHandler, this.dynamicProxiesHandler);
        this.buildTimeInitializationHandler = new InitializationHandler();
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return true;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        ArrayList<Class<? extends Feature>> fs = new ArrayList<Class<? extends Feature>>();
        fs.add(DynamicProxyFeature.class);
        fs.add(ResourcesFeature.class);
        fs.add(ReflectionFeature.class);
        return fs;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (ConfigOptions.isFeatureMode()) {
            this.reflectionHandler.register(access);
            this.dynamicProxiesHandler.register(access);
        }
        if (ConfigOptions.isFunctionalMode()) {
            this.reflectionHandler.registerFunctional(access);
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.resourcesHandler.register(access);
        this.buildTimeInitializationHandler.register(access);
        if (ConfigOptions.isFeatureMode()) {
            System.out.println("Number of types dynamically registered for reflective access: #" + this.reflectionHandler.getTypesRegisteredForReflectiveAccessCount());
            this.reflectionHandler.dump();
        }
    }

    public static void log(String msg) {
        if (ConfigOptions.isVerbose()) {
            System.out.println(msg);
        }
    }
}

