/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import org.springframework.graalvm.domain.reflect.ClassDescriptor;
import org.springframework.graalvm.domain.reflect.JsonConverter;
import org.springframework.graalvm.domain.reflect.JsonMarshaller;
import org.springframework.graalvm.domain.reflect.ReflectionDescriptor;

public class ReflectionJsonStrip {
    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 2) {
            System.out.println("Usage: ReflectionJsonStrip <input-reflect-config.json> <target-reflect-config.json>");
            System.exit(1);
        }
        ReflectionDescriptor rd1 = null;
        try (FileInputStream fis = new FileInputStream(new File(args[0]));){
            rd1 = JsonMarshaller.read(fis);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem loading file 1", e);
        }
        ReflectionDescriptor rd2 = null;
        try (FileInputStream fis = new FileInputStream(new File(args[1]));){
            rd2 = JsonMarshaller.read(fis);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem loading file 2", e);
        }
        List<ClassDescriptor> cds1 = rd1.getClassDescriptors();
        List<ClassDescriptor> cds2 = rd2.getClassDescriptors();
        File newStrippedFile = new File(args[1] + ".stripped");
        StringBuilder json = new StringBuilder();
        json.append("[\n");
        for (ClassDescriptor cd2 : cds2) {
            if (ReflectionJsonStrip.getClassDescriptor(cds1, cd2.getName()) != null) continue;
            System.out.println("Did not find " + cd2.getName() + " in the first file, including it in output");
            json.append(new JsonConverter().toJsonObject(cd2).toString() + ",\n");
        }
        json.setCharAt(json.length() - 2, ' ');
        json.append("\n]");
        String output = json.toString();
        try (FileOutputStream fos = new FileOutputStream(newStrippedFile);){
            fos.write(output.getBytes());
        }
    }

    private static ClassDescriptor getClassDescriptor(List<ClassDescriptor> cds, String name) {
        for (ClassDescriptor cd : cds) {
            if (!cd.getName().equals(name)) continue;
            return cd;
        }
        return null;
    }
}

