/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import org.springframework.graalvm.domain.reflect.ClassDescriptor;
import org.springframework.graalvm.domain.reflect.Flag;
import org.springframework.graalvm.domain.reflect.JsonMarshaller;
import org.springframework.graalvm.domain.reflect.MethodDescriptor;
import org.springframework.graalvm.domain.reflect.ReflectionDescriptor;

public class ReflectionJsonPrintDuplicates {
    public static void main(String[] args) {
        if (args == null || args.length != 1) {
            System.out.println("Usage: ReflectionJsonComparator <reflect-config.json>");
            System.exit(1);
        }
        ReflectionDescriptor rd1 = null;
        try (FileInputStream fis = new FileInputStream(new File(args[0]));){
            rd1 = JsonMarshaller.read(fis);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem loading file 1", e);
        }
        List<ClassDescriptor> cds = rd1.getClassDescriptors();
        for (ClassDescriptor cd : cds) {
            List<MethodDescriptor> methods;
            if (cd.getFlags() != null && cd.getFlags().contains((Object)Flag.allDeclaredMethods)) {
                methods = cd.getMethods();
                boolean specifiesMethods = false;
                if (methods != null) {
                    for (MethodDescriptor md : methods) {
                        if (md.getName().equals("<init>")) continue;
                        specifiesMethods = true;
                    }
                }
                if (specifiesMethods) {
                    System.out.println("Removing allDeclaredMethods for " + cd.getName());
                    cd.unsetFlag(Flag.allDeclaredMethods);
                }
            }
            if (cd.getFlags() == null || !cd.getFlags().contains((Object)Flag.allDeclaredConstructors)) continue;
            methods = cd.getMethods();
            boolean specifiesConstructors = false;
            if (methods != null) {
                for (MethodDescriptor md : methods) {
                    if (!md.getName().equals("<init>")) continue;
                    specifiesConstructors = true;
                }
            }
            if (!specifiesConstructors) continue;
            System.out.println("Removing allDeclaredConstructors for " + cd.getName());
            cd.unsetFlag(Flag.allDeclaredConstructors);
        }
        try (FileOutputStream fos = new FileOutputStream(new File(args[0] + ".2"));){
            JsonMarshaller.write(rd1, fos);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem writing file", e);
        }
    }

    private static ClassDescriptor getClassDescriptor(List<ClassDescriptor> cds, String name) {
        for (ClassDescriptor cd : cds) {
            if (!cd.getName().equals(name)) continue;
            return cd;
        }
        return null;
    }
}

