/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graalvm.support;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.springframework.graalvm.domain.reflect.ClassDescriptor;
import org.springframework.graalvm.domain.reflect.JsonMarshaller;
import org.springframework.graalvm.domain.reflect.ReflectionDescriptor;

public class ReflectionJsonComparator {
    public static void main(String[] args) {
        ClassDescriptor cd2;
        if (args == null || args.length != 2) {
            System.out.println("Usage: ReflectionJsonComparator <reflect-config1.json> <reflect-config2.json>");
            System.exit(1);
        }
        ReflectionDescriptor rd1 = null;
        try (FileInputStream fis = new FileInputStream(new File(args[0]));){
            rd1 = JsonMarshaller.read(fis);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem loading file 1", e);
        }
        ReflectionDescriptor rd2 = null;
        try (FileInputStream fis = new FileInputStream(new File(args[1]));){
            rd2 = JsonMarshaller.read(fis);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem loading file 2", e);
        }
        List<ClassDescriptor> cds1 = rd1.getClassDescriptors();
        List<ClassDescriptor> cds2 = rd2.getClassDescriptors();
        int firstNotInSecond = 0;
        int secondNotInFirst = 0;
        int sameInBoth = 0;
        int differentInBoth = 0;
        System.out.println("These are in the first reflection file but not in the second:");
        for (ClassDescriptor cd1 : cds1) {
            if (ReflectionJsonComparator.getClassDescriptor(cds2, cd1.getName()) != null) continue;
            System.out.println("< " + cd1.toString());
            ++firstNotInSecond;
        }
        System.out.println("These are in the second reflection file but not in the first:");
        for (ClassDescriptor cd22 : cds2) {
            if (ReflectionJsonComparator.getClassDescriptor(cds1, cd22.getName()) != null) continue;
            System.out.println("> " + cd22.toString());
            ++secondNotInFirst;
        }
        System.out.println("These are in both files and configured the same:");
        for (ClassDescriptor cd1 : cds1) {
            cd2 = ReflectionJsonComparator.getClassDescriptor(cds2, cd1.getName());
            if (cd2 == null || !cd1.equals(cd2)) continue;
            System.out.println("= " + cd1);
            ++sameInBoth;
        }
        System.out.println("These are in both files but configured differently in each:");
        for (ClassDescriptor cd1 : cds1) {
            cd2 = ReflectionJsonComparator.getClassDescriptor(cds2, cd1.getName());
            if (cd2 == null || cd1.equals(cd2)) continue;
            System.out.println("1?" + cd1);
            System.out.println("2?" + cd2);
            ++differentInBoth;
        }
        System.out.println("Summary:");
        System.out.println("In first but not second: " + firstNotInSecond);
        System.out.println("In second but not first: " + secondNotInFirst);
        System.out.println("In both files but configured differently: " + differentInBoth);
        System.out.println("In both files and configured the same: " + sameInBoth);
    }

    private static ClassDescriptor getClassDescriptor(List<ClassDescriptor> cds, String name) {
        for (ClassDescriptor cd : cds) {
            if (!cd.getName().equals(name)) continue;
            return cd;
        }
        return null;
    }
}

